/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.s3;

import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.collect.Lists;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.model.Run;
import hudson.plugins.s3.ClientHelper;
import hudson.plugins.s3.Destination;
import hudson.plugins.s3.FileHelper;
import hudson.plugins.s3.FingerprintRecord;
import hudson.plugins.s3.S3Artifact;
import hudson.plugins.s3.callable.MasterSlaveCallable;
import hudson.plugins.s3.callable.S3BaseUploadCallable;
import hudson.plugins.s3.callable.S3CleanupUploadCallable;
import hudson.plugins.s3.callable.S3DownloadCallable;
import hudson.plugins.s3.callable.S3GzipCallable;
import hudson.plugins.s3.callable.S3UploadCallable;
import hudson.plugins.s3.callable.S3WaitUploadCallable;
import hudson.util.Secret;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import org.apache.commons.io.FilenameUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class S3Profile {
    private final String name;
    private final String accessKey;
    private final Secret secretKey;
    private final int maxUploadRetries;
    private final int uploadRetryTime;
    private final int maxDownloadRetries;
    private final int downloadRetryTime;
    private final boolean keepStructure;
    private final boolean useRole;
    private final int signedUrlExpirySeconds;

    @DataBoundConstructor
    public S3Profile(String name, String accessKey, String secretKey, boolean useRole, int signedUrlExpirySeconds, String maxUploadRetries, String uploadRetryTime, String maxDownloadRetries, String downloadRetryTime, boolean keepStructure) {
        this.name = name;
        this.useRole = useRole;
        this.maxUploadRetries = this.parseWithDefault(maxUploadRetries, 5);
        this.uploadRetryTime = this.parseWithDefault(uploadRetryTime, 5);
        this.maxDownloadRetries = this.parseWithDefault(maxDownloadRetries, 5);
        this.downloadRetryTime = this.parseWithDefault(downloadRetryTime, 5);
        this.signedUrlExpirySeconds = signedUrlExpirySeconds;
        if (useRole) {
            this.accessKey = "";
            this.secretKey = null;
        } else {
            this.accessKey = accessKey;
            this.secretKey = Secret.fromString((String)secretKey);
        }
        this.keepStructure = keepStructure;
    }

    public boolean isKeepStructure() {
        return this.keepStructure;
    }

    private int parseWithDefault(String number, int defaultValue) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public int getMaxDownloadRetries() {
        return this.maxDownloadRetries;
    }

    public int getDownloadRetryTime() {
        return this.downloadRetryTime;
    }

    public final String getAccessKey() {
        return this.accessKey;
    }

    public final Secret getSecretKey() {
        return this.secretKey;
    }

    public final int getMaxUploadRetries() {
        return this.maxUploadRetries;
    }

    public final int getUploadRetryTime() {
        return this.uploadRetryTime;
    }

    public String getName() {
        return this.name;
    }

    public final boolean getUseRole() {
        return this.useRole;
    }

    public boolean isUseRole() {
        return this.useRole;
    }

    public int getSignedUrlExpirySeconds() {
        return this.signedUrlExpirySeconds;
    }

    public AmazonS3Client getClient(String region) {
        return ClientHelper.createClient(this.accessKey, Secret.toString((Secret)this.secretKey), this.useRole, region, this.getProxy());
    }

    public List<FingerprintRecord> upload(Run<?, ?> run, String bucketName, List<FilePath> filePaths, List<String> fileNames, Map<String, String> userMetadata, String storageClass, String selregion, final boolean uploadFromSlave, boolean managedArtifacts, boolean useServerSideEncryption, boolean gzipFiles) throws IOException, InterruptedException {
        ArrayList<FingerprintRecord> fingerprints = new ArrayList<FingerprintRecord>(fileNames.size());
        try {
            for (int i = 0; i < fileNames.size(); ++i) {
                boolean produced;
                Destination dest;
                final FilePath filePath = filePaths.get(i);
                String fileName = fileNames.get(i);
                if (managedArtifacts) {
                    dest = Destination.newFromRun(run, bucketName, fileName, true);
                    produced = run.getTimeInMillis() <= filePath.lastModified() + 2000L;
                } else {
                    dest = new Destination(bucketName, fileName);
                    produced = false;
                }
                S3BaseUploadCallable upload = gzipFiles ? new S3GzipCallable(this.accessKey, this.secretKey, this.useRole, dest, userMetadata, storageClass, selregion, useServerSideEncryption, this.getProxy()) : new S3UploadCallable(this.accessKey, this.secretKey, this.useRole, dest, userMetadata, storageClass, selregion, useServerSideEncryption, this.getProxy());
                FingerprintRecord fingerprintRecord = this.repeat(this.maxUploadRetries, this.uploadRetryTime, dest, new Callable<FingerprintRecord>((MasterSlaveCallable)((Object)upload), produced, bucketName, fileName, selregion){
                    final /* synthetic */ MasterSlaveCallable val$upload;
                    final /* synthetic */ boolean val$produced;
                    final /* synthetic */ String val$bucketName;
                    final /* synthetic */ String val$fileName;
                    final /* synthetic */ String val$selregion;
                    {
                        this.val$upload = masterSlaveCallable;
                        this.val$produced = bl2;
                        this.val$bucketName = string;
                        this.val$fileName = string2;
                        this.val$selregion = string3;
                    }

                    @Override
                    public FingerprintRecord call() throws IOException, InterruptedException {
                        String md5 = (String)S3Profile.this.invoke(uploadFromSlave, filePath, this.val$upload);
                        return new FingerprintRecord(this.val$produced, this.val$bucketName, this.val$fileName, this.val$selregion, md5);
                    }
                });
                fingerprints.add(fingerprintRecord);
            }
            this.waitUploads(filePaths, uploadFromSlave);
        }
        catch (IOException | InterruptedException exception) {
            this.cleanupUploads(filePaths, uploadFromSlave);
            throw exception;
        }
        return fingerprints;
    }

    private void cleanupUploads(List<FilePath> filePaths, boolean uploadFromSlave) {
        for (FilePath filePath : filePaths) {
            try {
                this.invoke(uploadFromSlave, filePath, new S3CleanupUploadCallable());
            }
            catch (IOException | InterruptedException exception) {}
        }
    }

    private void waitUploads(List<FilePath> filePaths, boolean uploadFromSlave) throws InterruptedException, IOException {
        for (FilePath filePath : filePaths) {
            this.invoke(uploadFromSlave, filePath, new S3WaitUploadCallable());
        }
    }

    private <T> T invoke(boolean uploadFromSlave, FilePath filePath, MasterSlaveCallable<T> callable) throws InterruptedException, IOException {
        if (uploadFromSlave) {
            return (T)filePath.act(callable);
        }
        return callable.invoke(filePath);
    }

    public List<String> list(Run build, String bucket) {
        ObjectListing objectListing;
        AmazonS3Client s3client = this.getClient(ClientHelper.DEFAULT_AMAZON_S3_REGION_NAME);
        String buildName = build.getDisplayName();
        int buildID = build.getNumber();
        Destination dest = new Destination(bucket, "jobs/" + buildName + '/' + buildID + '/' + this.name);
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(dest.bucketName).withPrefix(dest.objectName).withEncodingType("url");
        ArrayList files = Lists.newArrayList();
        do {
            objectListing = s3client.listObjects(listObjectsRequest);
            for (S3ObjectSummary summary : objectListing.getObjectSummaries()) {
                GetObjectRequest req = new GetObjectRequest(dest.bucketName, summary.getKey());
                files.add(req.getKey());
            }
            listObjectsRequest.setMarker(objectListing.getNextMarker());
        } while (objectListing.isTruncated());
        return files;
    }

    public List<FingerprintRecord> downloadAll(Run build, List<FingerprintRecord> artifacts, String includeFilter, String excludeFilter, FilePath targetDir, boolean flatten) throws IOException, InterruptedException {
        ArrayList fingerprints = Lists.newArrayList();
        for (FingerprintRecord record : artifacts) {
            final S3Artifact artifact = record.getArtifact();
            final Destination dest = Destination.newFromRun(build, artifact);
            final FilePath target = this.getFilePath(targetDir, flatten, artifact.getName());
            if (!FileHelper.selected(includeFilter, excludeFilter, artifact.getName())) continue;
            fingerprints.add(this.repeat(this.maxDownloadRetries, this.downloadRetryTime, dest, new Callable<FingerprintRecord>(){

                @Override
                public FingerprintRecord call() throws IOException, InterruptedException {
                    String md5 = (String)target.act((FilePath.FileCallable)new S3DownloadCallable(S3Profile.this.accessKey, S3Profile.this.secretKey, S3Profile.this.useRole, dest, artifact.getRegion(), S3Profile.this.getProxy()));
                    return new FingerprintRecord(true, dest.bucketName, target.getName(), artifact.getRegion(), md5);
                }
            }));
        }
        return fingerprints;
    }

    private <T> T repeat(int maxRetries, int waitTime, Destination dest, Callable<T> func) throws IOException, InterruptedException {
        int retryCount = 0;
        while (true) {
            try {
                return func.call();
            }
            catch (Exception e) {
                if (++retryCount >= maxRetries) {
                    throw new IOException("Call fails for " + dest + ": " + e + ":: Failed after " + retryCount + " tries.", e);
                }
                Thread.sleep(TimeUnit.SECONDS.toMillis(waitTime));
                continue;
            }
            break;
        }
    }

    private FilePath getFilePath(FilePath targetDir, boolean flatten, String fullName) {
        if (flatten) {
            return new FilePath(targetDir, FilenameUtils.getName((String)fullName));
        }
        return new FilePath(targetDir, fullName);
    }

    public void delete(Run run, FingerprintRecord record) {
        Destination dest = Destination.newFromRun(run, record.getArtifact());
        DeleteObjectRequest req = new DeleteObjectRequest(dest.bucketName, dest.objectName);
        AmazonS3Client client = this.getClient(record.getArtifact().getRegion());
        client.deleteObject(req);
    }

    public String toString() {
        return "S3Profile{name='" + this.name + '\'' + ", accessKey='" + this.accessKey + '\'' + ", secretKey=" + this.secretKey + ", useRole=" + this.useRole + '}';
    }

    private ProxyConfiguration getProxy() {
        return Jenkins.get().proxy;
    }
}

