/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.s3;

import com.google.common.collect.Maps;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.Descriptor;
import hudson.model.EnvironmentContributingAction;
import hudson.model.Fingerprint;
import hudson.model.FingerprintMap;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.copyartifact.BuildFilter;
import hudson.plugins.copyartifact.BuildSelector;
import hudson.plugins.copyartifact.ParametersBuildFilter;
import hudson.plugins.copyartifact.StatusBuildSelector;
import hudson.plugins.copyartifact.WorkspaceSelector;
import hudson.plugins.s3.FingerprintRecord;
import hudson.plugins.s3.Messages;
import hudson.plugins.s3.S3ArtifactsAction;
import hudson.plugins.s3.S3BucketPublisher;
import hudson.plugins.s3.S3Profile;
import hudson.security.AccessControlled;
import hudson.security.SecurityRealm;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.Fingerprinter;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class S3CopyArtifact
extends Builder
implements SimpleBuildStep {
    private String projectName;
    private final String filter;
    private final String excludeFilter;
    private final String target;
    private BuildSelector selector;
    private final Boolean flatten;
    private final Boolean optional;
    private static final BuildSelector DEFAULT_BUILD_SELECTOR = new StatusBuildSelector(true);

    @DataBoundConstructor
    public S3CopyArtifact(String projectName, BuildSelector buildSelector, String filter, String excludeFilter, String target, boolean flatten, boolean optional) {
        if (projectName.indexOf(36) < 0 && new JobResolver((String)projectName).job == null) {
            projectName = "";
        }
        this.projectName = projectName;
        this.selector = buildSelector;
        if (this.selector == null) {
            this.selector = DEFAULT_BUILD_SELECTOR;
        }
        this.filter = Util.fixNull((String)filter).trim();
        this.excludeFilter = Util.fixNull((String)excludeFilter).trim();
        this.target = Util.fixNull((String)target).trim();
        this.flatten = flatten ? Boolean.TRUE : null;
        this.optional = optional ? Boolean.TRUE : null;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public BuildSelector getBuildSelector() {
        return this.selector;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getExcludeFilter() {
        return this.excludeFilter;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean isFlatten() {
        return this.flatten != null && this.flatten != false;
    }

    public boolean isOptional() {
        return this.optional != null && this.optional != false;
    }

    private void setResult(@Nonnull Run<?, ?> run, boolean isOk) {
        if (this.isOptional()) {
            return;
        }
        if (isOk) {
            run.setResult(Result.SUCCESS);
        } else {
            run.setResult(Result.FAILURE);
        }
    }

    public void perform(@Nonnull Run<?, ?> dst, @Nonnull FilePath targetDir, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        PrintStream console = listener.getLogger();
        String expandedProject = this.projectName;
        String includeFilter = this.getFilter();
        String excludeFilter = this.getExcludeFilter();
        try {
            EnvVars env = dst.getEnvironment(listener);
            expandedProject = env.expand(this.projectName);
            JobResolver job = new JobResolver(expandedProject);
            if (job.job != null && !expandedProject.equals(this.projectName) && !job.job.getACL().hasPermission((Authentication)new UsernamePasswordAuthenticationToken((Object)"authenticated", (Object)"", new GrantedAuthority[]{SecurityRealm.AUTHENTICATED_AUTHORITY}), Item.READ)) {
                job.job = null;
            }
            if (job.job == null) {
                console.println(Messages.CopyArtifact_MissingProject(expandedProject));
                this.setResult(dst, false);
                return;
            }
            Run src = this.getBuildSelector().getBuild(job.job, env, job.filter, dst);
            if (src == null) {
                console.println(Messages.CopyArtifact_MissingBuild(expandedProject));
                this.setResult(dst, false);
                return;
            }
            if (!targetDir.exists()) {
                console.println(Messages.CopyArtifact_MissingSrcWorkspace());
                this.setResult(dst, false);
                return;
            }
            EnvAction envData = (EnvAction)dst.getAction(EnvAction.class);
            if (envData != null) {
                envData.add(expandedProject, src.getNumber());
            }
            if (!this.target.isEmpty()) {
                targetDir = new FilePath(targetDir, env.expand(this.target));
            }
            if ((includeFilter = env.expand(includeFilter)).trim().isEmpty()) {
                includeFilter = "**";
            }
            excludeFilter = env.expand(excludeFilter);
            if (src instanceof MavenModuleSetBuild) {
                boolean ok = this.perform(src, dst, includeFilter, excludeFilter, targetDir, console);
                for (Run r : ((MavenModuleSetBuild)src).getModuleLastBuilds().values()) {
                    ok |= this.perform(r, dst, includeFilter, excludeFilter, targetDir, console);
                }
                this.setResult(dst, ok);
            } else if (src instanceof MatrixBuild) {
                boolean ok = false;
                for (Run r : ((MatrixBuild)src).getExactRuns()) {
                    FilePath subdir = targetDir.child(r.getParent().getName());
                    ok |= this.perform(r, dst, includeFilter, excludeFilter, subdir, console);
                }
                this.setResult(dst, ok);
            } else {
                this.setResult(dst, this.perform(src, dst, includeFilter, excludeFilter, targetDir, console));
            }
        }
        catch (IOException ex) {
            Util.displayIOException((IOException)ex, (TaskListener)listener);
            ex.printStackTrace(listener.error(Messages.CopyArtifact_FailedToCopy(expandedProject, includeFilter)));
            this.setResult(dst, false);
        }
    }

    private boolean perform(Run src, Run<?, ?> dst, String includeFilter, String excludeFilter, FilePath targetDir, PrintStream console) throws IOException, InterruptedException {
        S3ArtifactsAction action = (S3ArtifactsAction)src.getAction(S3ArtifactsAction.class);
        if (action == null) {
            console.println("Build " + src.getDisplayName() + '[' + src.number + "] doesn't have any S3 artifacts uploaded");
            return false;
        }
        S3Profile profile = S3BucketPublisher.getProfile(action.getProfile());
        if (profile == null) {
            console.println("Can't find S3 profile");
            return false;
        }
        targetDir.mkdirs();
        List<FingerprintRecord> records = profile.downloadAll(src, action.getArtifacts(), includeFilter, excludeFilter, targetDir, this.isFlatten());
        HashMap fingerprints = Maps.newHashMap();
        for (FingerprintRecord record : records) {
            FingerprintMap map = Jenkins.getInstance().getFingerprintMap();
            Fingerprint f = map.getOrCreate(src, record.getName(), record.getFingerprint());
            f.addFor(src);
            f.addFor(dst);
            fingerprints.put(record.getName(), record.getFingerprint());
        }
        for (Run r : new Run[]{src, dst}) {
            if (r == null) continue;
            Fingerprinter.FingerprintAction fa = (Fingerprinter.FingerprintAction)r.getAction(Fingerprinter.FingerprintAction.class);
            if (fa != null) {
                fa.add((Map)fingerprints);
                continue;
            }
            r.getActions().add(new Fingerprinter.FingerprintAction(r, (Map)fingerprints));
        }
        console.println(MessageFormat.format("Copied {0} {0,choice,0#artifacts|1#artifact|1<artifacts} from \"{1}\" build number {2} stored in S3", fingerprints.size(), HyperlinkNote.encodeTo((String)('/' + src.getParent().getUrl()), (String)src.getParent().getFullDisplayName()), HyperlinkNote.encodeTo((String)('/' + src.getUrl()), (String)Integer.toString(src.getNumber()))));
        return !fingerprints.isEmpty() || this.isOptional();
    }

    private static class EnvAction
    implements EnvironmentContributingAction {
        private transient Map<String, String> data = new HashMap<String, String>();

        private EnvAction() {
        }

        private void add(String projectName, int buildNumber) {
            if (this.data == null) {
                return;
            }
            int i = projectName.indexOf(47);
            if (i > 0) {
                projectName = projectName.substring(0, i);
            }
            this.data.put("COPYARTIFACT_BUILD_NUMBER_" + projectName.toUpperCase().replaceAll("[^A-Z]+", "_"), Integer.toString(buildNumber));
        }

        public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
            if (this.data != null) {
                env.putAll(this.data);
            }
        }

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public String getUrlName() {
            return null;
        }
    }

    @Extension
    public static final class CopyArtifactRunListener
    extends RunListener<Build> {
        public CopyArtifactRunListener() {
            super(Build.class);
        }

        public void onStarted(Build r, TaskListener listener) {
            if (((Project)r.getProject()).getBuildersList().get(S3CopyArtifact.class) != null) {
                r.addAction((Action)new EnvAction());
            }
        }
    }

    @Extension
    public static final class ListenerImpl
    extends ItemListener {
        public void onRenamed(Item item, String oldName, String newName) {
            for (AbstractProject project : Jenkins.get().getAllItems(AbstractProject.class)) {
                for (S3CopyArtifact ca : ListenerImpl.getCopiers(project)) {
                    try {
                        if (ca.getProjectName().equals(oldName)) {
                            ca.projectName = newName;
                        } else {
                            if (!ca.getProjectName().startsWith(oldName + '/')) continue;
                            ca.projectName = newName + ca.projectName.substring(oldName.length());
                        }
                        project.save();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ListenerImpl.class.getName()).log(Level.WARNING, "Failed to resave project " + project.getName() + " for project rename in S3 Copy Artifact build step (" + oldName + " =>" + newName + ')', ex);
                    }
                }
            }
        }

        private static List<S3CopyArtifact> getCopiers(AbstractProject project) {
            DescribableList list;
            Object object = project instanceof Project ? ((Project)project).getBuildersList() : (list = project instanceof MatrixProject ? ((MatrixProject)project).getBuildersList() : null);
            if (list == null) {
                return Collections.emptyList();
            }
            return list.getAll(S3CopyArtifact.class);
        }
    }

    @Extension
    @Symbol(value={"s3CopyArtifact"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckProjectName(@AncestorInPath AccessControlled anc, @QueryParameter String value) {
            AbstractProject nearProject;
            if (!anc.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            Job<?, ?> item = new JobResolver((String)value).job;
            FormValidation result = item != null ? (item instanceof MavenModuleSet ? FormValidation.warning((String)Messages.CopyArtifact_MavenProject()) : (item instanceof MatrixProject ? FormValidation.warning((String)Messages.CopyArtifact_MatrixProject()) : FormValidation.ok())) : (value.indexOf(36) >= 0 ? FormValidation.warning((String)Messages.CopyArtifact_ParameterizedName()) : ((nearProject = AbstractProject.findNearest((String)value)) != null ? FormValidation.error((String)Messages.BuildTrigger_NoSuchProjectWithSuggestion(value, nearProject.getName())) : FormValidation.error((String)Messages.BuildTrigger_NoSuchProject(value))));
            return result;
        }

        public boolean isApplicable(Class<? extends AbstractProject> clazz) {
            return true;
        }

        public String getDisplayName() {
            return "S3 Copy Artifact";
        }

        public DescriptorExtensionList<BuildSelector, Descriptor<BuildSelector>> getBuildSelectors() {
            DescriptorExtensionList list = DescriptorExtensionList.createDescriptorList((Jenkins)Jenkins.getInstance(), BuildSelector.class);
            list.remove((Object)WorkspaceSelector.DESCRIPTOR);
            return list;
        }
    }

    private static class JobResolver {
        Job<?, ?> job;
        BuildFilter filter = new BuildFilter();

        JobResolver(String projectName) {
            ParametersBuildFilter pFilter;
            Job candidate;
            int i;
            Jenkins jenkins = Jenkins.get();
            this.job = (Job)jenkins.getItemByFullName(projectName, Job.class);
            if (this.job == null && (i = projectName.indexOf(47)) > 0 && (candidate = (Job)jenkins.getItemByFullName(projectName.substring(0, i), Job.class)) != null && (pFilter = new ParametersBuildFilter(projectName.substring(i + 1))).isValid(candidate)) {
                this.job = candidate;
                this.filter = pFilter;
            }
        }
    }
}

