/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.s3;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.plugins.s3.MetadataPair;
import hudson.util.ListBoxModel;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public final class Entry
implements Describable<Entry> {
    public String bucket;
    public String sourceFile;
    public String excludedFile;
    static final String[] storageClasses = new String[]{"STANDARD", "STANDARD_IA", "REDUCED_REDUNDANCY"};
    public String storageClass;
    public static final List<Region> regions = RegionUtils.getRegionsForService((String)"s3");
    public String selectedRegion;
    public boolean noUploadOnFailure;
    public boolean uploadFromSlave;
    public boolean managedArtifacts;
    public boolean useServerSideEncryption;
    public boolean flatten;
    public boolean gzipFiles;
    public boolean showDirectlyInBrowser;
    public boolean keepForever;
    public List<MetadataPair> userMetadata;
    @Extension
    public static final DescriptorImpl DESCRIPOR = new DescriptorImpl();

    @DataBoundConstructor
    public Entry(String bucket, String sourceFile, String excludedFile, String storageClass, String selectedRegion, boolean noUploadOnFailure, boolean uploadFromSlave, boolean managedArtifacts, boolean useServerSideEncryption, boolean flatten, boolean gzipFiles, boolean keepForever, boolean showDirectlyInBrowser, List<MetadataPair> userMetadata) {
        this.bucket = bucket;
        this.sourceFile = sourceFile;
        this.excludedFile = excludedFile;
        this.storageClass = storageClass;
        this.selectedRegion = selectedRegion;
        this.noUploadOnFailure = noUploadOnFailure;
        this.uploadFromSlave = uploadFromSlave;
        this.managedArtifacts = managedArtifacts;
        this.useServerSideEncryption = useServerSideEncryption;
        this.flatten = flatten;
        this.gzipFiles = gzipFiles;
        this.keepForever = keepForever;
        this.userMetadata = userMetadata;
        this.showDirectlyInBrowser = showDirectlyInBrowser;
    }

    public Descriptor<Entry> getDescriptor() {
        return DESCRIPOR;
    }

    public static class DescriptorImpl
    extends Descriptor<Entry> {
        public String getDisplayName() {
            return "File to upload";
        }

        public ListBoxModel doFillStorageClassItems() {
            ListBoxModel model = new ListBoxModel();
            for (String s : storageClasses) {
                model.add(s, s);
            }
            return model;
        }

        public ListBoxModel doFillSelectedRegionItems() {
            ListBoxModel model = new ListBoxModel();
            for (Region r : regions) {
                model.add(r.getName(), r.getName());
            }
            return model;
        }
    }
}

