/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.rolestrategy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public enum RoleType {
    Global,
    Project,
    Slave;


    @Deprecated
    @SuppressFBWarnings(value={"NM_METHOD_NAMING_CONVENTION"}, justification="deprecated, just for API compatibility")
    public static RoleType FromString(String roleName) {
        return RoleType.fromString(roleName);
    }

    public static RoleType fromString(String roleName) {
        if (roleName.equals("globalRoles")) {
            return Global;
        }
        if (roleName.equals("projectRoles")) {
            return Project;
        }
        if (roleName.equals("slaveRoles")) {
            return Slave;
        }
        throw new IllegalArgumentException("Unexpected roleName=" + roleName);
    }

    public String getStringType() {
        switch (this) {
            case Global: {
                return "globalRoles";
            }
            case Project: {
                return "projectRoles";
            }
            case Slave: {
                return "slaveRoles";
            }
        }
        throw new IllegalArgumentException("Unsupported Role: " + String.valueOf((Object)this));
    }
}

