/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.rolestrategy;

import com.michelin.cio.hudson.plugins.rolestrategy.AuthorizationType;
import com.michelin.cio.hudson.plugins.rolestrategy.Messages;
import com.michelin.cio.hudson.plugins.rolestrategy.PermissionEntry;
import com.michelin.cio.hudson.plugins.rolestrategy.PermissionTemplate;
import com.michelin.cio.hudson.plugins.rolestrategy.Role;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleMap;
import com.michelin.cio.hudson.plugins.rolestrategy.ValidationUtil;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleType;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractItem;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.View;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.SecurityRealm;
import hudson.security.SidACL;
import hudson.util.FormValidation;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.rolestrategy.AmbiguousSidsAdminMonitor;
import org.jenkinsci.plugins.rolestrategy.permissions.PermissionHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.GET;
import org.kohsuke.stapler.verb.POST;

public class RoleBasedAuthorizationStrategy
extends AuthorizationStrategy {
    private static Logger LOGGER = Logger.getLogger(RoleBasedAuthorizationStrategy.class.getName());
    public static final String GLOBAL = "globalRoles";
    public static final String PROJECT = "projectRoles";
    public static final String SLAVE = "slaveRoles";
    public static final String PERMISSION_TEMPLATES = "permissionTemplates";
    public static final String MACRO_ROLE = "roleMacros";
    public static final String MACRO_USER = "userMacros";
    private final RoleMap agentRoles;
    private final RoleMap globalRoles;
    private final RoleMap itemRoles;
    private Map<String, PermissionTemplate> permissionTemplates;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public RoleBasedAuthorizationStrategy() {
        this.agentRoles = new RoleMap();
        this.globalRoles = new RoleMap();
        this.itemRoles = new RoleMap();
        this.permissionTemplates = new TreeMap<String, PermissionTemplate>();
    }

    public RoleBasedAuthorizationStrategy(Map<String, RoleMap> grantedRoles) {
        this(grantedRoles, null);
    }

    public RoleBasedAuthorizationStrategy(Map<String, RoleMap> grantedRoles, @CheckForNull Set<PermissionTemplate> permissionTemplates) {
        RoleMap map;
        this.permissionTemplates = new TreeMap<String, PermissionTemplate>();
        if (permissionTemplates != null) {
            for (PermissionTemplate template : permissionTemplates) {
                this.permissionTemplates.put(template.getName(), template);
            }
        }
        this.agentRoles = (map = grantedRoles.get(SLAVE)) == null ? new RoleMap() : map;
        map = grantedRoles.get(GLOBAL);
        this.globalRoles = map == null ? new RoleMap() : map;
        map = grantedRoles.get(PROJECT);
        this.itemRoles = map == null ? new RoleMap() : map;
        this.refreshPermissionsFromTemplate();
    }

    private void refreshPermissionsFromTemplate() {
        SortedMap<Role, Set<PermissionEntry>> roles = this.getGrantedRolesEntries(PROJECT);
        for (Role role : roles.keySet()) {
            if (Util.fixEmptyAndTrim((String)role.getTemplateName()) == null) continue;
            role.refreshPermissionsFromTemplate(this.permissionTemplates.get(role.getTemplateName()));
        }
    }

    @NonNull
    public SidACL getRootACL() {
        return this.globalRoles.getACL(RoleType.Global, null);
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public RoleMap getRoleMap(RoleType roleType) {
        switch (roleType) {
            case Global: {
                return this.globalRoles;
            }
            case Project: {
                return this.itemRoles;
            }
            case Slave: {
                return this.agentRoles;
            }
        }
        throw new IllegalArgumentException("Unknown RoleType: " + String.valueOf((Object)roleType));
    }

    @NonNull
    public ACL getACL(@NonNull Job<?, ?> project) {
        return this.getACL((AbstractItem)project);
    }

    @NonNull
    public ACL getACL(@NonNull AbstractItem project) {
        return this.itemRoles.newMatchingRoleMap(project.getFullName()).getACL(RoleType.Project, (AccessControlled)project).newInheritingACL(this.getRootACL());
    }

    @NonNull
    public ACL getACL(@NonNull Computer computer) {
        return this.agentRoles.newMatchingRoleMap(computer.getName()).getACL(RoleType.Slave, (AccessControlled)computer).newInheritingACL(this.getRootACL());
    }

    @NonNull
    public ACL getACL(@NonNull Node node) {
        return this.agentRoles.newMatchingRoleMap(node.getNodeName()).getACL(RoleType.Slave, (AccessControlled)node).newInheritingACL(this.getRootACL());
    }

    @NonNull
    public Collection<String> getGroups() {
        HashSet<String> sids = new HashSet<String>();
        sids.addAll(this.filterRoleSids(this.globalRoles));
        sids.addAll(this.filterRoleSids(this.itemRoles));
        sids.addAll(this.filterRoleSids(this.agentRoles));
        return sids;
    }

    private Set<String> filterRoleSids(RoleMap roleMap) {
        return roleMap.getSidEntries(false).stream().filter(entry -> entry.getType() != AuthorizationType.USER).map(PermissionEntry::getSid).collect(Collectors.toSet());
    }

    @Deprecated
    @Nullable
    public SortedMap<Role, Set<String>> getGrantedRoles(String type) {
        return this.getRoleMap(RoleType.fromString(type)).getGrantedRoles();
    }

    @Deprecated
    public SortedMap<Role, Set<String>> getGrantedRoles(@NonNull RoleType type) {
        return this.getRoleMap(type).getGrantedRoles();
    }

    public Set<PermissionTemplate> getPermissionTemplates() {
        return Set.copyOf(this.permissionTemplates.values());
    }

    @CheckForNull
    public PermissionTemplate getPermissionTemplate(String templateName) {
        return this.permissionTemplates.get(templateName);
    }

    public boolean hasPermissionTemplate(String name) {
        return this.permissionTemplates.containsKey(name);
    }

    public SortedMap<Role, Set<PermissionEntry>> getGrantedRolesEntries(@NonNull String type) {
        return this.getGrantedRolesEntries(RoleType.fromString(type));
    }

    public SortedMap<Role, Set<PermissionEntry>> getGrantedRolesEntries(@NonNull RoleType type) {
        return this.getRoleMap(type).getGrantedRolesEntries();
    }

    public Set<PermissionEntry> getSidEntries(String type) {
        return this.getRoleMap(RoleType.fromString(type)).getSidEntries();
    }

    @Deprecated
    @CheckForNull
    public Set<String> getSIDs(String type) {
        return this.getRoleMap(RoleType.fromString(type)).getSids();
    }

    @NonNull
    private Map<RoleType, RoleMap> getRoleMaps() {
        HashMap<RoleType, RoleMap> roleMaps = new HashMap<RoleType, RoleMap>();
        roleMaps.put(RoleType.Global, this.globalRoles);
        roleMaps.put(RoleType.Slave, this.agentRoles);
        roleMaps.put(RoleType.Project, this.itemRoles);
        return Collections.unmodifiableMap(roleMaps);
    }

    private void addRole(RoleType roleType, Role role) {
        this.getRoleMap(roleType).addRole(role);
    }

    private void assignRole(RoleType type, Role role, PermissionEntry sid) {
        RoleMap roleMap = this.getRoleMap(type);
        if (roleMap.hasRole(role)) {
            roleMap.assignRole(role, sid);
        }
    }

    private static void persistChanges() throws IOException {
        Jenkins j = RoleBasedAuthorizationStrategy.instance();
        j.save();
        AuthorizationStrategy as = j.getAuthorizationStrategy();
        if (as instanceof RoleBasedAuthorizationStrategy) {
            RoleBasedAuthorizationStrategy rbas = (RoleBasedAuthorizationStrategy)as;
            rbas.validateConfig();
        }
    }

    private static Jenkins instance() {
        return Jenkins.get();
    }

    private static void checkAdminPerm() {
        RoleBasedAuthorizationStrategy.instance().checkPermission(Jenkins.ADMINISTER);
    }

    @POST
    @Restricted(value={NoExternalUse.class})
    public void doAddTemplate(@QueryParameter(required=true) String name, @QueryParameter(required=true) String permissionIds, @QueryParameter(required=false) boolean overwrite) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        List<String> permissionList = Arrays.asList(permissionIds.split(","));
        Set<Permission> permissionSet = PermissionHelper.fromStrings(permissionList, true);
        PermissionTemplate template = new PermissionTemplate(permissionSet, name);
        if (!overwrite && this.hasPermissionTemplate(name)) {
            Stapler.getCurrentResponse2().sendError(400, "A template with name " + name + " already exists.");
            return;
        }
        this.permissionTemplates.put(name, template);
        this.refreshPermissionsFromTemplate();
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @POST
    @Restricted(value={NoExternalUse.class})
    public void doRemoveTemplates(@QueryParameter(required=true) String names, @QueryParameter(required=false) boolean force) throws IOException {
        String[] split;
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        for (String templateName : split = names.split(",")) {
            PermissionTemplate pt = this.getPermissionTemplate(templateName = templateName.trim());
            if (pt == null || pt.isUsed() && !force) continue;
            this.permissionTemplates.remove(templateName);
            RoleMap roleMap = this.getRoleMap(RoleType.Project);
            for (Role role : roleMap.getRoles()) {
                if (!templateName.equals(role.getTemplateName())) continue;
                role.setTemplateName(null);
            }
        }
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doAddRole(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleName, @QueryParameter(required=true) String permissionIds, @QueryParameter(required=true) String overwrite, @QueryParameter(required=false) String pattern, @QueryParameter(required=false) String template) throws IOException {
        RoleMap roleMap;
        Role role2;
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        boolean overwriteb = Boolean.parseBoolean(overwrite);
        String pttrn = ".*";
        String templateName = Util.fixEmptyAndTrim((String)template);
        if (!type.equals(GLOBAL) && pattern != null) {
            pttrn = pattern;
        }
        List<String> permissionList = Arrays.asList(permissionIds.split(","));
        Set<Permission> permissionSet = PermissionHelper.fromStrings(permissionList, true);
        Role role = new Role(roleName, pttrn, permissionSet);
        if (PROJECT.equals(type) && templateName != null) {
            if (!this.hasPermissionTemplate(template)) {
                Stapler.getCurrentResponse2().sendError(400, "A template with name " + template + " doesn't exists.");
                return;
            }
            role.setTemplateName(templateName);
            role.refreshPermissionsFromTemplate(this.getPermissionTemplate(templateName));
        }
        RoleType roleType = RoleType.fromString(type);
        if (overwriteb && (role2 = (roleMap = this.getRoleMap(roleType)).getRole(roleName)) != null) {
            roleMap.removeRole(role2);
        }
        this.addRole(roleType, role);
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doRemoveRoles(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleNames) throws IOException {
        String[] split;
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        RoleMap roleMap = this.getRoleMap(RoleType.fromString(type));
        for (String roleName : split = roleNames.split(",")) {
            Role role = roleMap.getRole(roleName);
            if (role == null) continue;
            roleMap.removeRole(role);
        }
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @Deprecated
    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doAssignRole(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleName, @QueryParameter(required=true) String sid) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        RoleType roleType = RoleType.fromString(type);
        Role role = this.getRoleMap(roleType).getRole(roleName);
        if (role != null) {
            this.assignRole(roleType, role, new PermissionEntry(AuthorizationType.EITHER, sid));
        }
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doAssignUserRole(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleName, @QueryParameter(required=true) String user) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        RoleType roleType = RoleType.fromString(type);
        Role role = this.getRoleMap(roleType).getRole(roleName);
        if (role != null) {
            this.assignRole(roleType, role, new PermissionEntry(AuthorizationType.USER, user));
        }
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doAssignGroupRole(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleName, @QueryParameter(required=true) String group) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        RoleType roleType = RoleType.fromString(type);
        Role role = this.getRoleMap(roleType).getRole(roleName);
        if (role != null) {
            this.assignRole(roleType, role, new PermissionEntry(AuthorizationType.GROUP, group));
        }
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doDeleteSid(@QueryParameter(required=true) String type, @QueryParameter(required=true) String sid) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        this.getRoleMap(RoleType.fromString(type)).deleteSids(new PermissionEntry(AuthorizationType.EITHER, sid));
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doDeleteUser(@QueryParameter(required=true) String type, @QueryParameter(required=true) String user) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        this.getRoleMap(RoleType.fromString(type)).deleteSids(new PermissionEntry(AuthorizationType.USER, user));
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doDeleteGroup(@QueryParameter(required=true) String type, @QueryParameter(required=true) String group) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        this.getRoleMap(RoleType.fromString(type)).deleteSids(new PermissionEntry(AuthorizationType.GROUP, group));
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doUnassignRole(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleName, @QueryParameter(required=true) String sid) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        RoleMap roleMap = this.getRoleMap(RoleType.fromString(type));
        Role role = roleMap.getRole(roleName);
        if (role != null) {
            roleMap.deleteRoleSid(new PermissionEntry(AuthorizationType.EITHER, sid), role.getName());
        }
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doUnassignUserRole(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleName, @QueryParameter(required=true) String user) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        RoleMap roleMap = this.getRoleMap(RoleType.fromString(type));
        Role role = roleMap.getRole(roleName);
        if (role != null) {
            roleMap.deleteRoleSid(new PermissionEntry(AuthorizationType.USER, user), role.getName());
        }
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doUnassignGroupRole(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleName, @QueryParameter(required=true) String group) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        RoleMap roleMap = this.getRoleMap(RoleType.fromString(type));
        Role role = roleMap.getRole(roleName);
        if (role != null) {
            roleMap.deleteRoleSid(new PermissionEntry(AuthorizationType.GROUP, group), role.getName());
        }
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @GET
    @Restricted(value={NoExternalUse.class})
    public void doGetTemplate(@QueryParameter(required=true) String name) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        JSONObject responseJson = new JSONObject();
        PermissionTemplate template = this.permissionTemplates.get(name);
        if (template != null) {
            Set<Permission> permissions = template.getPermissions();
            HashMap<String, Boolean> permissionsMap = new HashMap<String, Boolean>();
            for (Permission permission : permissions) {
                permissionsMap.put(permission.getId(), permission.getEnabled());
            }
            responseJson.put("permissionIds", permissionsMap);
            responseJson.put("isUsed", (Object)template.isUsed());
        }
        Stapler.getCurrentResponse2().setContentType("application/json;charset=UTF-8");
        PrintWriter writer = Stapler.getCurrentResponse2().getWriter();
        responseJson.write((Writer)writer);
        ((Writer)writer).close();
    }

    @GET
    @Restricted(value={NoExternalUse.class})
    public void doGetRole(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleName) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        JSONObject responseJson = new JSONObject();
        RoleMap roleMap = this.getRoleMap(RoleType.fromString(type));
        Role role = roleMap.getRole(roleName);
        if (role != null) {
            Set<Permission> permissions = role.getPermissions();
            HashMap<String, Boolean> permissionsMap = new HashMap<String, Boolean>();
            for (Permission permission : permissions) {
                permissionsMap.put(permission.getId(), permission.getEnabled());
            }
            responseJson.put("permissionIds", permissionsMap);
            if (!type.equals(GLOBAL)) {
                responseJson.put("pattern", (Object)role.getPattern().pattern());
            }
            SortedMap<Role, Set<PermissionEntry>> grantedRoleMap = roleMap.getGrantedRolesEntries();
            responseJson.put("sids", grantedRoleMap.get(role));
            if (type.equals(PROJECT)) {
                responseJson.put("template", (Object)role.getTemplateName());
            }
        }
        Stapler.getCurrentResponse2().setContentType("application/json;charset=UTF-8");
        PrintWriter writer = Stapler.getCurrentResponse2().getWriter();
        responseJson.write((Writer)writer);
        ((Writer)writer).close();
    }

    @GET
    @Restricted(value={NoExternalUse.class})
    public void doGetAllRoles(@QueryParameter(fixEmpty=true) String type) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        JSONObject responseJson = new JSONObject();
        RoleMap roleMap = this.getRoleMap(RoleType.Global);
        if (type != null) {
            roleMap = this.getRoleMap(RoleType.fromString(type));
        }
        for (Map.Entry<Role, Set<PermissionEntry>> grantedRole : roleMap.getGrantedRolesEntries().entrySet()) {
            responseJson.put(grantedRole.getKey().getName(), grantedRole.getValue());
        }
        Stapler.getCurrentResponse2().setContentType("application/json;charset=UTF-8");
        PrintWriter writer = Stapler.getCurrentResponse2().getWriter();
        responseJson.write((Writer)writer);
        ((Writer)writer).close();
    }

    @GET
    @Restricted(value={NoExternalUse.class})
    public void doGetRoleAssignments(@QueryParameter(fixEmpty=true) String type) throws IOException {
        RoleBasedAuthorizationStrategy.instance().checkPermission(Jenkins.SYSTEM_READ);
        SortedSet<PermissionEntry> sidEntries = this.getRoleMap(RoleType.fromString(type)).getSidEntries(true);
        JSONArray responseJson = new JSONArray();
        for (PermissionEntry entry : sidEntries) {
            JSONObject userEntry = new JSONObject();
            userEntry.put("name", (Object)entry.getSid());
            userEntry.put("type", (Object)entry.getType().toString());
            JSONArray roles = new JSONArray();
            SortedMap<Role, Set<PermissionEntry>> rolesEntries = this.getGrantedRolesEntries(type);
            for (Map.Entry<Role, Set<PermissionEntry>> roleEntry : rolesEntries.entrySet()) {
                if (!roleEntry.getValue().contains(entry)) continue;
                roles.add((Object)roleEntry.getKey().getName());
            }
            userEntry.put("roles", (Object)roles);
            responseJson.add((Object)userEntry);
        }
        Stapler.getCurrentResponse2().setContentType("application/json;charset=UTF-8");
        PrintWriter writer = Stapler.getCurrentResponse2().getWriter();
        responseJson.write((Writer)writer);
        ((Writer)writer).close();
    }

    @GET
    @Restricted(value={NoExternalUse.class})
    public void doGetMatchingJobs(@QueryParameter(required=true) String pattern, @QueryParameter int maxJobs) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        ArrayList<String> matchingItems = new ArrayList<String>();
        int itemCount = RoleMap.getMatchingItemNames(matchingItems, Pattern.compile(pattern), maxJobs);
        JSONObject responseJson = new JSONObject();
        responseJson.put("matchingJobs", matchingItems);
        responseJson.put("itemCount", (Object)itemCount);
        StaplerResponse2 response = Stapler.getCurrentResponse2();
        response.setContentType("application/json;charset=UTF-8");
        PrintWriter writer = response.getWriter();
        responseJson.write((Writer)writer);
        ((Writer)writer).close();
    }

    @GET
    @Restricted(value={NoExternalUse.class})
    public void doGetMatchingAgents(@QueryParameter(required=true) String pattern, @QueryParameter int maxAgents) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        ArrayList<String> matchingAgents = new ArrayList<String>();
        int agentCount = RoleMap.getMatchingAgentNames(matchingAgents, Pattern.compile(pattern), maxAgents);
        JSONObject responseJson = new JSONObject();
        responseJson.put("matchingAgents", matchingAgents);
        responseJson.put("agentCount", (Object)agentCount);
        StaplerResponse2 response = Stapler.getCurrentResponse2();
        response.setContentType("application/json;charset=UTF-8");
        PrintWriter writer = response.getWriter();
        responseJson.write((Writer)writer);
        ((Writer)writer).close();
    }

    @Restricted(value={NoExternalUse.class})
    public void validateConfig() {
        ArrayList<PermissionEntry> sids = new ArrayList<PermissionEntry>();
        sids.addAll(this.getSidEntries(GLOBAL));
        sids.addAll(this.getSidEntries(SLAVE));
        sids.addAll(this.getSidEntries(PROJECT));
        AmbiguousSidsAdminMonitor.get().updateEntries(sids);
    }

    @Initializer(after=InitMilestone.SYSTEM_CONFIG_LOADED)
    public static void init() {
        Jenkins j = RoleBasedAuthorizationStrategy.instance();
        AuthorizationStrategy as = j.getAuthorizationStrategy();
        if (as instanceof RoleBasedAuthorizationStrategy) {
            RoleBasedAuthorizationStrategy rbas = (RoleBasedAuthorizationStrategy)as;
            rbas.validateConfig();
        }
    }

    @CheckForNull
    public static RoleBasedAuthorizationStrategy getInstance() {
        AuthorizationStrategy authStrategy;
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        AuthorizationStrategy authorizationStrategy = authStrategy = jenkins != null ? jenkins.getAuthorizationStrategy() : null;
        if (authStrategy instanceof RoleBasedAuthorizationStrategy) {
            return (RoleBasedAuthorizationStrategy)authStrategy;
        }
        return null;
    }

    @Deprecated
    public static boolean isCreateAllowed() {
        return true;
    }

    public static final class DescriptorImpl
    extends Descriptor<AuthorizationStrategy> {
        @NonNull
        public String getDisplayName() {
            return Messages.RoleBasedAuthorizationStrategy_DisplayName();
        }

        @RequirePOST
        public FormValidation doCheckForWhitespace(@QueryParameter String value) {
            RoleBasedAuthorizationStrategy.checkAdminPerm();
            if (value == null || value.trim().equals(value)) {
                return FormValidation.ok();
            }
            return FormValidation.warning((String)Messages.RoleBasedProjectNamingStrategy_WhiteSpaceWillBeTrimmed());
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public void doRolesSubmit(StaplerRequest2 req, StaplerResponse2 rsp) throws ServletException, IOException {
            RoleBasedAuthorizationStrategy.checkAdminPerm();
            req.setCharacterEncoding("UTF-8");
            JSONObject json = req.getSubmittedForm();
            AuthorizationStrategy strategy = this.newInstance(req, json);
            RoleBasedAuthorizationStrategy.instance().setAuthorizationStrategy(strategy);
            RoleBasedAuthorizationStrategy.persistChanges();
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public void doAssignSubmit(JSONObject json) throws ServletException, IOException {
            RoleBasedAuthorizationStrategy.checkAdminPerm();
            AuthorizationStrategy oldStrategy = RoleBasedAuthorizationStrategy.instance().getAuthorizationStrategy();
            if (json.has(RoleBasedAuthorizationStrategy.GLOBAL) && json.has(RoleBasedAuthorizationStrategy.PROJECT) && oldStrategy instanceof RoleBasedAuthorizationStrategy) {
                RoleBasedAuthorizationStrategy strategy = (RoleBasedAuthorizationStrategy)oldStrategy;
                Map<RoleType, RoleMap> maps = strategy.getRoleMaps();
                for (Map.Entry<RoleType, RoleMap> map : maps.entrySet()) {
                    RoleMap roleMap = map.getValue();
                    JSONArray userEntries = json.getJSONArray(map.getKey().getStringType());
                    roleMap.clearSids();
                    userEntries.forEach(e -> {
                        JSONObject entry = (JSONObject)e;
                        PermissionEntry pe = new PermissionEntry(AuthorizationType.valueOf(entry.getString("type")), entry.getString("name"));
                        entry.getJSONArray("roles").forEach(r -> {
                            Role role = roleMap.getRole((String)r);
                            if (role != null) {
                                roleMap.assignRole(role, pe);
                            }
                        });
                    });
                }
                RoleBasedAuthorizationStrategy.persistChanges();
            }
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public void doTemplatesSubmit(StaplerRequest2 req, StaplerResponse2 rsp) throws ServletException, IOException {
            RoleBasedAuthorizationStrategy.checkAdminPerm();
            req.setCharacterEncoding("UTF-8");
            JSONObject json = req.getSubmittedForm();
            AuthorizationStrategy oldStrategy = RoleBasedAuthorizationStrategy.instance().getAuthorizationStrategy();
            if (json.has(RoleBasedAuthorizationStrategy.PERMISSION_TEMPLATES) && oldStrategy instanceof RoleBasedAuthorizationStrategy) {
                RoleBasedAuthorizationStrategy strategy = (RoleBasedAuthorizationStrategy)oldStrategy;
                JSONObject permissionTemplatesJson = json.getJSONObject(RoleBasedAuthorizationStrategy.PERMISSION_TEMPLATES);
                TreeMap<String, PermissionTemplate> permissionTemplates = new TreeMap<String, PermissionTemplate>();
                for (Map.Entry r : permissionTemplatesJson.getJSONObject("data").entrySet()) {
                    String templateName = (String)r.getKey();
                    HashSet<String> permissionStrings = new HashSet<String>();
                    for (Map.Entry e : ((JSONObject)r.getValue()).entrySet()) {
                        if (!((Boolean)e.getValue()).booleanValue()) continue;
                        permissionStrings.add((String)e.getKey());
                    }
                    PermissionTemplate permissionTemplate = new PermissionTemplate(templateName, permissionStrings);
                    permissionTemplates.put(templateName, permissionTemplate);
                }
                strategy.permissionTemplates = permissionTemplates;
                strategy.refreshPermissionsFromTemplate();
                RoleBasedAuthorizationStrategy.persistChanges();
            }
        }

        public AuthorizationStrategy newInstance(StaplerRequest2 req, JSONObject formData) {
            RoleBasedAuthorizationStrategy strategy;
            AuthorizationStrategy oldStrategy = RoleBasedAuthorizationStrategy.instance().getAuthorizationStrategy();
            if (formData.has(RoleBasedAuthorizationStrategy.GLOBAL) && formData.has(RoleBasedAuthorizationStrategy.PROJECT) && formData.has(RoleBasedAuthorizationStrategy.SLAVE) && oldStrategy instanceof RoleBasedAuthorizationStrategy) {
                strategy = new RoleBasedAuthorizationStrategy();
                this.readRoles(formData, RoleType.Global, strategy, (RoleBasedAuthorizationStrategy)oldStrategy);
                this.readRoles(formData, RoleType.Project, strategy, (RoleBasedAuthorizationStrategy)oldStrategy);
                this.readRoles(formData, RoleType.Slave, strategy, (RoleBasedAuthorizationStrategy)oldStrategy);
                strategy.permissionTemplates = ((RoleBasedAuthorizationStrategy)oldStrategy).permissionTemplates;
            } else if (oldStrategy instanceof RoleBasedAuthorizationStrategy) {
                strategy = (RoleBasedAuthorizationStrategy)oldStrategy;
            } else {
                strategy = new RoleBasedAuthorizationStrategy();
                Role adminRole = this.createAdminRole();
                strategy.addRole(RoleType.Global, adminRole);
                strategy.assignRole(RoleType.Global, adminRole, new PermissionEntry(AuthorizationType.USER, this.getCurrentUser()));
            }
            return strategy;
        }

        private void readRoles(JSONObject formData, RoleType roleType, RoleBasedAuthorizationStrategy targetStrategy, RoleBasedAuthorizationStrategy oldStrategy) {
            String roleTypeAsString = roleType.getStringType();
            JSONObject roles = formData.getJSONObject(roleTypeAsString);
            if (!roles.containsKey((Object)"data")) {
                assert (false) : "No data at role description";
                return;
            }
            for (Map.Entry r : roles.getJSONObject("data").entrySet()) {
                String pattern = ".*";
                if (((JSONObject)r.getValue()).has("pattern")) {
                    pattern = ((JSONObject)r.getValue()).getString("pattern");
                    ((JSONObject)r.getValue()).remove("pattern");
                }
                if (pattern == null) {
                    pattern = ".*";
                }
                String templateName = null;
                if (((JSONObject)r.getValue()).has("templateName")) {
                    templateName = ((JSONObject)r.getValue()).getString("templateName");
                    ((JSONObject)r.getValue()).remove("templateName");
                }
                HashSet<Permission> permissions = new HashSet<Permission>();
                for (Map.Entry e : ((JSONObject)r.getValue()).entrySet()) {
                    if (!((Boolean)e.getValue()).booleanValue()) continue;
                    Permission p = Permission.fromId((String)((String)e.getKey()));
                    permissions.add(p);
                }
                String roleName = (String)r.getKey();
                RoleMap roleMap = oldStrategy.getRoleMap(roleType);
                Role role = new Role(roleName, Pattern.compile(pattern), permissions, "", templateName);
                targetStrategy.addRole(roleType, role);
                Set<PermissionEntry> sids = roleMap.getSidEntriesForRole(roleName);
                if (sids == null) continue;
                for (PermissionEntry sid : sids) {
                    targetStrategy.assignRole(roleType, role, sid);
                }
            }
        }

        private Role createAdminRole() {
            HashSet<Permission> permissions = new HashSet<Permission>();
            permissions.add(Jenkins.ADMINISTER);
            return new Role("admin", permissions);
        }

        private String getCurrentUser() {
            PrincipalSid currentUser = new PrincipalSid(Jenkins.getAuthentication2());
            return currentUser.getPrincipal();
        }

        @Nullable
        public List<PermissionGroup> getGroups(@NonNull String type) {
            ArrayList<PermissionGroup> groups = new ArrayList<PermissionGroup>();
            ArrayList filterGroups = new ArrayList(PermissionGroup.getAll());
            switch (type) {
                case "globalRoles": {
                    break;
                }
                case "projectRoles": {
                    filterGroups.remove(PermissionGroup.get(Hudson.class));
                    filterGroups.remove(PermissionGroup.get(Computer.class));
                    break;
                }
                case "slaveRoles": {
                    filterGroups.remove(PermissionGroup.get(Permission.class));
                    filterGroups.remove(PermissionGroup.get(Hudson.class));
                    filterGroups.remove(PermissionGroup.get(View.class));
                    filterGroups.remove(PermissionGroup.get(Item.class));
                    filterGroups.remove(PermissionGroup.get(SCM.class));
                    filterGroups.remove(PermissionGroup.get(Run.class));
                    break;
                }
                default: {
                    filterGroups = new ArrayList();
                }
            }
            block10: for (PermissionGroup group : filterGroups) {
                if (group == PermissionGroup.get(Permission.class)) continue;
                for (Permission p : group.getPermissions()) {
                    if (!p.getEnabled()) continue;
                    groups.add(group);
                    continue block10;
                }
            }
            return groups;
        }

        @Restricted(value={NoExternalUse.class})
        public boolean showPermission(String type, Permission p) {
            switch (type) {
                case "globalRoles": {
                    if (PermissionHelper.isDangerous(p)) {
                        return false;
                    }
                    return p.getEnabled();
                }
                case "projectRoles": {
                    return p.getEnabled();
                }
                case "slaveRoles": {
                    return p != Computer.CREATE && p.getEnabled();
                }
            }
            return false;
        }

        @Restricted(value={DoNotUse.class})
        public String impliedByList(Permission p) {
            ArrayList<Permission> impliedBys = new ArrayList<Permission>();
            while (p.impliedBy != null) {
                p = p.impliedBy;
                impliedBys.add(p);
            }
            return StringUtils.join((Iterable)impliedBys.stream().map(Permission::getId).collect(Collectors.toList()), (String)" ");
        }

        @Restricted(value={DoNotUse.class})
        public PermissionEntry entryFor(String type, String sid) {
            if (type == null) {
                return null;
            }
            return new PermissionEntry(AuthorizationType.valueOf(type), sid);
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckPattern(@QueryParameter String value) {
            try {
                Pattern.compile(value);
            }
            catch (PatternSyntaxException pse) {
                return FormValidation.error((String)pse.getMessage());
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckName(@QueryParameter String value) {
            AuthorizationType type;
            String unbracketedValue = value.substring(1, value.length() - 1);
            int splitIndex = unbracketedValue.indexOf(58);
            if (splitIndex < 0) {
                return FormValidation.error((String)("No type prefix: " + unbracketedValue));
            }
            String typeString = unbracketedValue.substring(0, splitIndex);
            try {
                type = AuthorizationType.valueOf(typeString);
            }
            catch (Exception ex) {
                return FormValidation.error((String)("Invalid type prefix: " + unbracketedValue));
            }
            String sid = unbracketedValue.substring(splitIndex + 1);
            String escapedSid = Functions.escape((String)sid);
            if (!Jenkins.get().hasPermission(Jenkins.SYSTEM_READ)) {
                return FormValidation.ok((String)escapedSid);
            }
            SecurityRealm sr = Jenkins.get().getSecurityRealm();
            if (sid.equals("authenticated") && type == AuthorizationType.EITHER) {
                return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ValidationUtil.formatUserGroupValidationResponse(type, escapedSid, "Internal group found; but permissions would also be granted to a user of this name", true));
            }
            if (sid.equals("anonymous") && type == AuthorizationType.EITHER) {
                return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ValidationUtil.formatUserGroupValidationResponse(type, escapedSid, "Internal user found; but permissions would also be granted to a group of this name", true));
            }
            try {
                switch (type) {
                    case GROUP: {
                        FormValidation groupValidation = ValidationUtil.validateGroup(sid, sr, false);
                        if (groupValidation != null) {
                            return groupValidation;
                        }
                        return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ValidationUtil.formatNonExistentUserGroupValidationResponse(type, escapedSid, "Group not found"));
                    }
                    case USER: {
                        FormValidation userValidation = ValidationUtil.validateUser(sid, sr, false);
                        if (userValidation != null) {
                            return userValidation;
                        }
                        return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ValidationUtil.formatNonExistentUserGroupValidationResponse(type, escapedSid, "User not found"));
                    }
                    case EITHER: {
                        FormValidation userValidation = ValidationUtil.validateUser(sid, sr, true);
                        if (userValidation != null) {
                            return userValidation;
                        }
                        FormValidation groupValidation = ValidationUtil.validateGroup(sid, sr, true);
                        if (groupValidation != null) {
                            return groupValidation;
                        }
                        return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ValidationUtil.formatNonExistentUserGroupValidationResponse(type, escapedSid, "User or group not found", true));
                    }
                }
                return FormValidation.error((String)("Unexpected type: " + String.valueOf((Object)type)));
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)escapedSid);
            }
        }

        @Restricted(value={DoNotUse.class})
        public boolean hasAmbiguousEntries(SortedMap<Role, Set<PermissionEntry>> grantedRoles) {
            return grantedRoles.entrySet().stream().anyMatch(entry -> ((Set)entry.getValue()).stream().anyMatch(pe -> pe.getType() == AuthorizationType.EITHER));
        }
    }

    public static class ConverterImpl
    implements Converter {
        public boolean canConvert(Class type) {
            return type == RoleBasedAuthorizationStrategy.class;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            RoleBasedAuthorizationStrategy strategy = (RoleBasedAuthorizationStrategy)((Object)source);
            writer.startNode(RoleBasedAuthorizationStrategy.PERMISSION_TEMPLATES);
            for (PermissionTemplate permissionTemplate : strategy.permissionTemplates.values()) {
                writer.startNode("template");
                writer.addAttribute("name", permissionTemplate.getName());
                writer.startNode("permissions");
                for (Permission permission : permissionTemplate.getPermissions()) {
                    writer.startNode("permission");
                    writer.setValue(permission.getId());
                    writer.endNode();
                }
                writer.endNode();
                writer.endNode();
            }
            writer.endNode();
            Map<RoleType, RoleMap> maps = strategy.getRoleMaps();
            for (Map.Entry<RoleType, RoleMap> map : maps.entrySet()) {
                RoleMap roleMap = map.getValue();
                writer.startNode("roleMap");
                writer.addAttribute("type", map.getKey().getStringType());
                for (Map.Entry<Role, Set<PermissionEntry>> grantedRole : roleMap.getGrantedRolesEntries().entrySet()) {
                    Role role = grantedRole.getKey();
                    if (role == null) continue;
                    writer.startNode("role");
                    writer.addAttribute("name", role.getName());
                    writer.addAttribute("pattern", role.getPattern().pattern());
                    if (Util.fixEmptyAndTrim((String)role.getTemplateName()) != null) {
                        writer.addAttribute("templateName", role.getTemplateName());
                    }
                    writer.startNode("permissions");
                    for (Permission permission : role.getPermissions()) {
                        writer.startNode("permission");
                        writer.setValue(permission.getId());
                        writer.endNode();
                    }
                    writer.endNode();
                    writer.startNode("assignedSIDs");
                    for (PermissionEntry entry : grantedRole.getValue()) {
                        writer.startNode("sid");
                        writer.addAttribute("type", entry.getType().toString());
                        writer.setValue(entry.getSid());
                        writer.endNode();
                    }
                    writer.endNode();
                    writer.endNode();
                }
                writer.endNode();
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            HashMap<String, RoleMap> roleMaps = new HashMap<String, RoleMap>();
            HashSet<PermissionTemplate> permissionTemplates = new HashSet<PermissionTemplate>();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if (reader.getNodeName().equals(RoleBasedAuthorizationStrategy.PERMISSION_TEMPLATES)) {
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        HashSet<Permission> permissions = new HashSet<Permission>();
                        String name = reader.getAttribute("name");
                        String next = ((ExtendedHierarchicalStreamReader)reader).peekNextChild();
                        if (next != null && next.equals("permissions")) {
                            reader.moveDown();
                            while (reader.hasMoreChildren()) {
                                reader.moveDown();
                                Permission p = PermissionHelper.resolvePermissionFromString(reader.getValue());
                                if (p != null) {
                                    permissions.add(p);
                                }
                                reader.moveUp();
                            }
                            reader.moveUp();
                        }
                        permissionTemplates.add(new PermissionTemplate(permissions, name));
                        reader.moveUp();
                    }
                }
                if (reader.getNodeName().equals("roleMap")) {
                    String type = reader.getAttribute("type");
                    RoleMap map = new RoleMap();
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        String name = reader.getAttribute("name");
                        String pattern = reader.getAttribute("pattern");
                        String templateName = reader.getAttribute("templateName");
                        HashSet<Permission> permissions = new HashSet<Permission>();
                        String next = ((ExtendedHierarchicalStreamReader)reader).peekNextChild();
                        if (next != null && next.equals("permissions")) {
                            reader.moveDown();
                            while (reader.hasMoreChildren()) {
                                reader.moveDown();
                                Permission p = PermissionHelper.resolvePermissionFromString(reader.getValue());
                                if (p != null) {
                                    permissions.add(p);
                                }
                                reader.moveUp();
                            }
                            reader.moveUp();
                        }
                        Role role = new Role(name, Pattern.compile(pattern), permissions, "", templateName);
                        map.addRole(role);
                        next = ((ExtendedHierarchicalStreamReader)reader).peekNextChild();
                        if (next != null && next.equals("assignedSIDs")) {
                            reader.moveDown();
                            while (reader.hasMoreChildren()) {
                                reader.moveDown();
                                String entryTypeValue = reader.getAttribute("type");
                                AuthorizationType authType = AuthorizationType.EITHER;
                                String sid = reader.getValue();
                                if (entryTypeValue != null) {
                                    try {
                                        authType = AuthorizationType.valueOf(entryTypeValue);
                                    }
                                    catch (IllegalArgumentException ex) {
                                        LOGGER.log(Level.WARNING, "Unknown AuthorizationType {0} for SID {1} in Role {2}/{3}", new Object[]{entryTypeValue, sid, type, name});
                                        throw ex;
                                    }
                                }
                                PermissionEntry pe = new PermissionEntry(authType, sid);
                                map.assignRole(role, pe);
                                reader.moveUp();
                            }
                            reader.moveUp();
                        }
                        reader.moveUp();
                    }
                    roleMaps.put(type, map);
                }
                reader.moveUp();
            }
            return new RoleBasedAuthorizationStrategy(roleMaps, permissionTemplates);
        }

        protected RoleBasedAuthorizationStrategy create() {
            return new RoleBasedAuthorizationStrategy();
        }
    }
}

