/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.rolestrategy;

import com.michelin.cio.hudson.plugins.rolestrategy.PermissionTemplate;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.security.Permission;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.jenkinsci.plugins.rolestrategy.permissions.PermissionHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public final class Role
implements Comparable {
    public static final String GLOBAL_ROLE_PATTERN = ".*";
    private static final Logger LOGGER = Logger.getLogger(Role.class.getName());
    private final String name;
    private final Pattern pattern;
    @CheckForNull
    private final String description;
    @CheckForNull
    private String templateName;
    private final Set<Permission> permissions = new HashSet<Permission>();
    private transient Integer cachedHashCode = null;

    Role(String name, Set<Permission> permissions) {
        this(name, GLOBAL_ROLE_PATTERN, permissions);
    }

    Role(String name, String pattern, Set<Permission> permissions) {
        this(name, Pattern.compile(pattern), permissions, null);
    }

    @DataBoundConstructor
    public Role(@NonNull String name, @CheckForNull String pattern, @CheckForNull Set<String> permissionIds, @CheckForNull String description, String templateName) {
        this(name, Pattern.compile(pattern != null ? pattern : GLOBAL_ROLE_PATTERN), PermissionHelper.fromStrings(permissionIds, true), description, templateName);
    }

    public Role(@NonNull String name, @CheckForNull String pattern, @CheckForNull Set<String> permissionIds, @CheckForNull String description) {
        this(name, Pattern.compile(pattern != null ? pattern : GLOBAL_ROLE_PATTERN), PermissionHelper.fromStrings(permissionIds, true), description, "");
    }

    public Role(String name, Pattern pattern, Set<Permission> permissions, @CheckForNull String description) {
        this(name, pattern, permissions, description, "");
    }

    public Role(String name, Pattern pattern, Set<Permission> permissions, @CheckForNull String description, String templateName) {
        this.name = name;
        this.pattern = pattern;
        this.description = description;
        this.templateName = templateName;
        for (Permission perm : permissions) {
            if (perm == null) {
                LOGGER.log(Level.WARNING, "Found some null permission(s) in role " + this.name, new IllegalArgumentException());
                continue;
            }
            this.permissions.add(perm);
        }
    }

    public void setTemplateName(@CheckForNull String templateName) {
        this.templateName = templateName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getName() {
        return this.name;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Set<Permission> getPermissions() {
        return Collections.unmodifiableSet(this.permissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPermissions(Set<Permission> permissions) {
        Set<Permission> set = this.permissions;
        synchronized (set) {
            this.permissions.clear();
            this.permissions.addAll(permissions);
            this.cachedHashCode = this._hashCode();
        }
    }

    @Deprecated
    public void refreshPermissionsFromTemplate(Collection<PermissionTemplate> permissionTemplates) {
        if (Util.fixEmptyAndTrim((String)this.templateName) != null) {
            boolean found = false;
            for (PermissionTemplate pt : permissionTemplates) {
                if (!pt.getName().equals(this.templateName)) continue;
                this.setPermissions(pt.getPermissions());
                found = true;
                break;
            }
            if (!found) {
                this.templateName = null;
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    public void refreshPermissionsFromTemplate(@CheckForNull PermissionTemplate permissionTemplate) {
        if (permissionTemplate != null && this.templateName != null && this.templateName.equals(permissionTemplate.getName())) {
            this.setPermissions(permissionTemplate.getPermissions());
        }
    }

    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean hasPermission(Permission permission) {
        Set<Permission> set = this.permissions;
        synchronized (set) {
            return this.permissions.contains(permission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean hasAnyPermission(Set<Permission> permissions) {
        Set<Permission> set = this.permissions;
        synchronized (set) {
            return CollectionUtils.containsAny(this.permissions, permissions);
        }
    }

    public int compareTo(@NonNull Object o) {
        Objects.requireNonNull(o);
        if (o instanceof Role) {
            return this.name.compareTo(((Role)o).name);
        }
        return -1;
    }

    public int hashCode() {
        if (this.cachedHashCode == null) {
            this.cachedHashCode = this._hashCode();
        }
        return this.cachedHashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _hashCode() {
        int hash = 7;
        hash = 53 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 53 * hash + (this.pattern != null ? this.pattern.hashCode() : 0);
        Set<Permission> set = this.permissions;
        synchronized (set) {
            hash = 53 * hash + this.permissions.hashCode();
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Role other = (Role)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.pattern, other.pattern)) {
            return false;
        }
        Set<Permission> set = this.permissions;
        synchronized (set) {
            if (!Objects.equals(this.permissions, other.permissions)) {
                return false;
            }
        }
        return true;
    }
}

