/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.rolestrategy;

import com.michelin.cio.hudson.plugins.rolestrategy.PermissionEntry;
import com.michelin.cio.hudson.plugins.rolestrategy.Role;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleBasedAuthorizationStrategy;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleType;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.rolestrategy.permissions.PermissionHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

@Restricted(value={NoExternalUse.class})
public class PermissionTemplate
implements Comparable<PermissionTemplate> {
    private static final Logger LOGGER = Logger.getLogger(PermissionTemplate.class.getName());
    private final String name;
    private final Set<Permission> permissions = new HashSet<Permission>();

    @DataBoundConstructor
    public PermissionTemplate(String name, Set<String> permissions) {
        this(PermissionHelper.fromStrings(permissions, true), name);
    }

    public PermissionTemplate(Set<Permission> permissions, String name) {
        this.name = name;
        for (Permission perm : permissions) {
            if (perm == null) {
                LOGGER.log(Level.WARNING, "Found some null permission(s) in role " + this.name, new IllegalArgumentException());
                continue;
            }
            this.permissions.add(perm);
        }
    }

    public boolean isUsed() {
        AuthorizationStrategy auth = Jenkins.get().getAuthorizationStrategy();
        if (auth instanceof RoleBasedAuthorizationStrategy) {
            RoleBasedAuthorizationStrategy rbas = (RoleBasedAuthorizationStrategy)auth;
            SortedMap<Role, Set<PermissionEntry>> roleMap = rbas.getGrantedRolesEntries(RoleType.Project);
            for (Role role : roleMap.keySet()) {
                if (!Objects.equals(this.name, role.getTemplateName())) continue;
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public Set<Permission> getPermissions() {
        return Collections.unmodifiableSet(this.permissions);
    }

    public Boolean hasPermission(Permission permission) {
        return this.permissions.contains(permission);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PermissionTemplate other = (PermissionTemplate)obj;
        return Objects.equals(this.name, other.name);
    }

    @Override
    public int compareTo(@NonNull PermissionTemplate o) {
        return this.name.compareTo(o.name);
    }
}

