/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rolestrategy.casc;

import com.michelin.cio.hudson.plugins.rolestrategy.Role;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jenkinsci.plugins.rolestrategy.casc.PermissionFinder;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

@Restricted(value={NoExternalUse.class})
public class RoleDefinition {
    private transient Role role;
    @NonNull
    private final String name;
    @CheckForNull
    private final String description;
    @CheckForNull
    private final String pattern;
    private final Set<String> permissions;
    private final Set<String> assignments;

    @DataBoundConstructor
    public RoleDefinition(String name, String description, String pattern, Collection<String> permissions, Collection<String> assignments) {
        this.name = name;
        this.description = description;
        this.pattern = pattern;
        this.permissions = permissions != null ? new HashSet<String>(permissions) : Collections.emptySet();
        this.assignments = assignments != null ? new HashSet<String>(assignments) : Collections.emptySet();
        this.role = this.getRole();
    }

    public final Role getRole() {
        if (this.role == null) {
            HashSet<String> resolvedIds = new HashSet<String>();
            for (String id : this.permissions) {
                String resolvedId = PermissionFinder.findPermissionId(id);
                if (resolvedId != null) {
                    resolvedIds.add(resolvedId);
                    continue;
                }
                throw new IllegalStateException("Cannot resolve permission for ID: " + id);
            }
            this.role = new Role(this.name, this.pattern, resolvedIds, this.description);
        }
        return this.role;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Set<String> getPermissions() {
        return Collections.unmodifiableSet(this.permissions);
    }

    public Set<String> getAssignments() {
        return Collections.unmodifiableSet(this.assignments);
    }
}

