/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.rolestrategy;

import com.synopsys.arc.jenkins.plugins.rolestrategy.IMacroExtension;
import com.synopsys.arc.jenkins.plugins.rolestrategy.Macro;
import com.synopsys.arc.jenkins.plugins.rolestrategy.MacroException;
import com.synopsys.arc.jenkins.plugins.rolestrategy.macros.StubMacro;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Hudson;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RoleMacroExtension
implements ExtensionPoint,
IMacroExtension {
    private static final Map<String, RoleMacroExtension> Registry = new ConcurrentHashMap<String, RoleMacroExtension>();

    private static void updateRegistry() {
        Registry.clear();
        for (RoleMacroExtension ext : RoleMacroExtension.all()) {
            Registry.put(ext.getName(), ext);
        }
    }

    public static Macro getMacro(String unparsedMacroString) {
        try {
            return Macro.Parse(unparsedMacroString);
        }
        catch (MacroException ex) {
            return null;
        }
    }

    public static RoleMacroExtension getMacroExtension(String macroName) {
        RoleMacroExtension ext;
        if (Registry.isEmpty()) {
            RoleMacroExtension.updateRegistry();
        }
        return (ext = Registry.get(macroName)) != null ? ext : StubMacro.Instance;
    }

    public static ExtensionList<RoleMacroExtension> all() {
        return Hudson.getInstance().getExtensionList(RoleMacroExtension.class);
    }
}

