/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.reverse_proxy_auth.service;

import hudson.security.UserMayOrMayNotExistException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.ldap.LdapDataAccessException;
import org.acegisecurity.ldap.LdapUserSearch;
import org.acegisecurity.providers.ldap.LdapAuthoritiesPopulator;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;
import org.acegisecurity.userdetails.ldap.LdapUserDetailsImpl;
import org.apache.commons.collections.map.LRUMap;
import org.jenkinsci.plugins.reverse_proxy_auth.ReverseProxySecurityRealm;
import org.springframework.dao.DataAccessException;
import org.springframework.web.context.WebApplicationContext;

public class ProxyLDAPUserDetailsService
implements UserDetailsService {
    private static final Logger LOGGER = Logger.getLogger(ProxyLDAPUserDetailsService.class.getName());
    private static final int RETRY_TIMES = 3;
    private static final long MAX_WAIT_INTERVAL = 5000L;
    public final LdapUserSearch ldapSearch;
    public final LdapAuthoritiesPopulator authoritiesPopulator;
    private final LRUMap attributesCache = new LRUMap(32);

    public ProxyLDAPUserDetailsService(ReverseProxySecurityRealm securityRealm, WebApplicationContext appContext) {
        this.ldapSearch = securityRealm.extractBean(LdapUserSearch.class, appContext);
        this.authoritiesPopulator = securityRealm.extractBean(LdapAuthoritiesPopulator.class, appContext);
    }

    public ProxyLDAPUserDetailsService(LdapUserSearch ldapSearch, LdapAuthoritiesPopulator authoritiesPopulator) {
        this.ldapSearch = ldapSearch;
        this.authoritiesPopulator = authoritiesPopulator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public LdapUserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        for (int retries = 0; retries < 3; ++retries) {
            try {
                LdapUserDetails ldapUser = this.ldapSearch.searchForUser(username);
                if (ldapUser != null) {
                    GrantedAuthority[] extraAuthorities;
                    LdapUserDetailsImpl.Essence user = new LdapUserDetailsImpl.Essence(ldapUser);
                    Attributes v = ldapUser.getAttributes();
                    if (v instanceof BasicAttributes) {
                        LRUMap lRUMap = this.attributesCache;
                        synchronized (lRUMap) {
                            void var7_11;
                            Attributes attributes = (Attributes)this.attributesCache.get((Object)v);
                            if (attributes == null) {
                                Attributes attributes2 = v;
                                this.attributesCache.put((Object)v, (Object)attributes2);
                            }
                            user.setAttributes((Attributes)var7_11);
                        }
                    }
                    for (GrantedAuthority extraAuthority : extraAuthorities = this.authoritiesPopulator.getGrantedAuthorities(ldapUser)) {
                        user.addAuthority(extraAuthority);
                    }
                    ldapUser = user.createUserDetails();
                }
                return ldapUser;
            }
            catch (LdapDataAccessException ldapEx) {
                long waitTime = Math.min(this.getWaitTimeExp(retries), 5000L);
                String msg = String.format("Failed to search LDAP for username %s, will retry after waiting for %d milliseconds", username, waitTime);
                LOGGER.log(Level.WARNING, msg, ldapEx);
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.log(Level.WARNING, "Thread was interrupted while sleeping!");
                }
                continue;
            }
        }
        throw new UserMayOrMayNotExistException("Failed to search LDAP for user after all the retries.");
    }

    private long getWaitTimeExp(int retryCount) {
        long waitTime = (long)Math.pow(2.0, retryCount) * 1000L;
        return waitTime;
    }
}

