/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.reverse_proxy_auth.auth;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jenkinsci.plugins.reverse_proxy_auth.ReverseProxySearchTemplate;
import org.jenkinsci.plugins.reverse_proxy_auth.auth.ReverseProxyAuthoritiesPopulator;
import org.jenkinsci.plugins.reverse_proxy_auth.data.UserSearchTemplate;
import org.jenkinsci.plugins.reverse_proxy_auth.model.ReverseProxyUserDetails;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReverseProxyAuthoritiesPopulator
implements ReverseProxyAuthoritiesPopulator {
    private static final Log logger = LogFactory.getLog(DefaultReverseProxyAuthoritiesPopulator.class);
    private GrantedAuthority defaultRole;
    private final ReverseProxySearchTemplate reverseProxyTemplate;
    private String rolePrefix = "ROLE_";
    private boolean convertToUpperCase = true;
    protected Hashtable<String, GrantedAuthority[]> authContext;

    public DefaultReverseProxyAuthoritiesPopulator(Hashtable<String, GrantedAuthority[]> authContext) {
        this.authContext = authContext;
        this.reverseProxyTemplate = new ReverseProxySearchTemplate();
    }

    protected Set<GrantedAuthority> getAdditionalRoles(ReverseProxyUserDetails reverseProxyUser) {
        return null;
    }

    @Override
    public final GrantedAuthority[] getGrantedAuthorities(ReverseProxyUserDetails userDetails) {
        String username = userDetails.getUsername();
        Set<GrantedAuthority> roles = this.getGroupMembershipRoles(username);
        Set<GrantedAuthority> extraRoles = this.getAdditionalRoles(userDetails);
        if (extraRoles != null) {
            roles.addAll(extraRoles);
        }
        if (this.defaultRole != null) {
            roles.add(this.defaultRole);
        }
        return roles.toArray(new GrantedAuthority[roles.size()]);
    }

    public Set<GrantedAuthority> getGroupMembershipRoles(String username) {
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
        GrantedAuthority[] contextAuthorities = this.authContext.get(username);
        UserSearchTemplate searchTemplate = new UserSearchTemplate(username);
        Set<String> userRoles = this.reverseProxyTemplate.searchForSingleAttributeValues(searchTemplate, contextAuthorities);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Roles from search: " + userRoles));
        }
        for (String role : userRoles) {
            if (this.convertToUpperCase) {
                role = role.toUpperCase();
            }
            authorities.add((GrantedAuthority)new GrantedAuthorityImpl(this.rolePrefix + role));
        }
        return authorities;
    }

    public void setConvertToUpperCase(boolean convertToUpperCase) {
        this.convertToUpperCase = convertToUpperCase;
    }

    public void setDefaultRole(String defaultRole) {
        Assert.notNull((Object)defaultRole, (String)"The defaultRole property cannot be set to null");
        this.defaultRole = new GrantedAuthorityImpl(defaultRole);
    }

    public void setRolePrefix(String rolePrefix) {
        Assert.notNull((Object)rolePrefix, (String)"rolePrefix must not be null");
        this.rolePrefix = rolePrefix;
    }
}

