/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.jenkins.plugin.requests.model;

import com.michelin.cio.jenkins.plugin.requests.model.Messages;
import com.michelin.cio.jenkins.plugin.requests.model.Request;
import hudson.model.Item;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class DeleteFolderRequest
extends Request {
    private static final Logger LOGGER = Logger.getLogger(DeleteFolderRequest.class.getName());

    public DeleteFolderRequest(String requestType, String username, String project, String projectFullName, String buildNumber) {
        super(requestType, username, project, projectFullName, buildNumber);
    }

    @Override
    public String getMessage() {
        return Messages.DeleteFolderRequest_message(this.project);
    }

    @Override
    public boolean execute(Item item) {
        boolean success = false;
        try {
            if (Jenkins.getInstance().hasPermission(Item.DELETE)) {
                try {
                    item.delete();
                    success = true;
                    this.errorMessage = "The Folder " + item.getFullName() + " has been properly Deleted";
                    LOGGER.log(Level.INFO, "The folder {0} has been properly deleted", item.getFullName());
                }
                catch (IOException e) {
                    this.errorMessage = e.getMessage();
                    LOGGER.log(Level.SEVERE, "Unable to delete the folder " + item.getFullName(), e);
                }
                catch (InterruptedException e) {
                    this.errorMessage = e.getMessage();
                    LOGGER.log(Level.SEVERE, "Unable to delete the folder " + item.getFullName(), e);
                }
            } else {
                this.errorMessage = "The current user " + this.username + " does not have permission to delete the folder";
                LOGGER.log(Level.FINE, "The current user {0} does not have permission to DELETE the folder", new Object[]{this.username});
            }
        }
        catch (NullPointerException e) {
            this.errorMessage = e.getMessage();
            LOGGER.log(Level.SEVERE, "Unable to Delete the folder " + this.projectFullName + ":" + this.buildNumber, e.getMessage());
            return false;
        }
        return success;
    }
}

