/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.jenkins.plugin.requests.action;

import com.michelin.cio.jenkins.plugin.requests.RequestsPlugin;
import com.michelin.cio.jenkins.plugin.requests.action.Messages;
import com.michelin.cio.jenkins.plugin.requests.model.RequestsUtility;
import com.michelin.cio.jenkins.plugin.requests.model.UnlockRequest;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.Run;
import hudson.security.Permission;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class RequestUnlockAction
implements Action {
    public static final Logger LOGGER = Logger.getLogger(RequestUnlockAction.class.getName());
    private transient List<String> errors = new ArrayList<String>();
    private Run<?, ?> build;

    public RequestUnlockAction(Run<?, ?> target) {
        this.build = target;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(String errorString) {
        this.errors.clear();
        this.errors.add(errorString);
    }

    public HttpResponse doCreateUnlockRequest(StaplerRequest request, StaplerResponse response) throws IOException, ServletException, MessagingException {
        try {
            if (this.isIconDisplayed()) {
                String projectFullName;
                LOGGER.log(Level.FINE, "Unlock Build Request");
                this.errors.clear();
                String username = request.getParameter("username");
                RequestsPlugin plugin = (RequestsPlugin)Jenkins.getInstance().getPlugin(RequestsPlugin.class);
                String buildName = this.build.getDisplayName();
                String projectName = null;
                int buildNumber = this.build.getNumber();
                String fullDisplayName = this.build.getFullDisplayName();
                if (fullDisplayName.contains(" \u00bb ")) {
                    RequestsUtility requestsUtility = new RequestsUtility();
                    String[] nameList = requestsUtility.constructFolderJobNameAndFull(fullDisplayName);
                    projectName = nameList[0];
                    projectFullName = nameList[1];
                } else {
                    projectName = projectFullName = fullDisplayName.split(" #")[0];
                }
                String jenkinsUrl = Jenkins.getInstance().getRootUrl();
                String buildUrl = jenkinsUrl + this.build.getUrl();
                String[] emailData = new String[]{buildName, username, "An Unlock Build", buildUrl};
                plugin.addRequestPlusEmail(new UnlockRequest("unlockBuild", username, projectName, projectFullName, Integer.toString(buildNumber)), emailData);
            }
        }
        catch (NullPointerException e) {
            LOGGER.log(Level.SEVERE, "[ERROR] Exception: " + e.getMessage());
            return null;
        }
        return new HttpRedirect(request.getContextPath() + '/' + this.build.getUrl());
    }

    public String getDisplayName() {
        if (this.isIconDisplayed()) {
            return Messages.RequestUnlockAction_DisplayName();
        }
        return null;
    }

    public String getIconFileName() {
        if (this.isIconDisplayed()) {
            return "/images/24x24/lock.png";
        }
        return null;
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public String getUrlName() {
        return "request-unlock";
    }

    private boolean isIconDisplayed() {
        boolean isDisplayed = false;
        try {
            isDisplayed = !this.hasDeletePermission();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Impossible to know if the icon has to be displayed", e);
        }
        return isDisplayed;
    }

    private boolean hasDeletePermission() throws IOException, ServletException {
        return Functions.hasPermission((Permission)Run.DELETE);
    }
}

