/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.jenkins.plugin.requests.action;

import com.michelin.cio.jenkins.plugin.requests.RequestsPlugin;
import com.michelin.cio.jenkins.plugin.requests.action.Messages;
import com.michelin.cio.jenkins.plugin.requests.model.RenameJobRequest;
import com.michelin.cio.jenkins.plugin.requests.model.RequestsUtility;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Job;
import hudson.security.Permission;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class RequestRenameJobAction
implements Action {
    private Job<?, ?> project;
    private static final Logger LOGGER = Logger.getLogger(RequestRenameJobAction.class.getName());

    public RequestRenameJobAction(Job<?, ?> target) {
        this.project = target;
    }

    public HttpResponse doCreateRenameJobRequest(StaplerRequest request, StaplerResponse response) throws IOException, ServletException, MessagingException {
        try {
            if (this.isIconDisplayed()) {
                LOGGER.log(Level.FINE, "Renaming job request");
                String newName = request.getParameter("new-name");
                String username = request.getParameter("username");
                RequestsPlugin plugin = (RequestsPlugin)Jenkins.getInstance().getPlugin(RequestsPlugin.class);
                String projectName = this.project.getFullName();
                String projectFullName = this.project.getFullName();
                if (!projectFullName.contains("/job/") && projectFullName.contains("/")) {
                    RequestsUtility requestsUtility = new RequestsUtility();
                    projectFullName = requestsUtility.constructFolderJobName(projectFullName);
                }
                if (projectName.contains("/")) {
                    String[] projectnameList = projectName.split("/");
                    int nameCount = projectnameList.length;
                    projectName = projectnameList[nameCount - 1];
                }
                String[] emailData = new String[]{projectName + " -> " + newName, username, "A Rename Job", this.project.getAbsoluteUrl()};
                plugin.addRequestPlusEmail(new RenameJobRequest("renameJob", username, projectName, projectFullName, newName), emailData);
                LOGGER.log(Level.INFO, "The request to rename the job {0} to {1} has been sent to the administrator", new Object[]{this.project.getName(), newName});
            }
        }
        catch (NullPointerException e) {
            LOGGER.log(Level.SEVERE, "[ERROR] Exception: " + e.getMessage());
            return null;
        }
        return new HttpRedirect(request.getContextPath() + '/' + this.project.getUrl());
    }

    public String getDisplayName() {
        if (this.isIconDisplayed()) {
            return Messages.RequestRenameJobAction_DisplayName();
        }
        return null;
    }

    public String getIconFileName() {
        if (this.isIconDisplayed()) {
            return "/images/24x24/setting.png";
        }
        return null;
    }

    public Job<?, ?> getProject() {
        return this.project;
    }

    public String getUrlName() {
        return "request-rename-job";
    }

    private boolean isIconDisplayed() {
        boolean isDisplayed = false;
        try {
            isDisplayed = this.hasCreatePermission() && !this.hasDeletePermission() && !this.hasConfigurePermission() || this.hasDeletePermission() && !this.hasCreatePermission() && !this.hasConfigurePermission();
        }
        catch (IOException | ServletException e) {
            LOGGER.log(Level.WARNING, "Impossible to know if the icon has to be displayed", e);
        }
        return isDisplayed;
    }

    private boolean hasConfigurePermission() throws IOException, ServletException {
        return Functions.hasPermission(this.project, (Permission)Item.CONFIGURE);
    }

    private boolean hasCreatePermission() throws IOException, ServletException {
        return Functions.hasPermission(this.project, (Permission)Item.CREATE);
    }

    private boolean hasDeletePermission() throws IOException, ServletException {
        return Functions.hasPermission(this.project, (Permission)Item.DELETE);
    }
}

