/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.jenkins.plugin.requests.model;

import com.michelin.cio.jenkins.plugin.requests.model.Messages;
import com.michelin.cio.jenkins.plugin.requests.model.Request;
import com.michelin.cio.jenkins.plugin.requests.model.RequestsUtility;
import hudson.model.Item;
import hudson.model.Run;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class UnlockRequest
extends Request {
    private static final Logger LOGGER = Logger.getLogger(UnlockRequest.class.getName());

    public UnlockRequest(String requestType, String username, String project, String projectFullName, String buildNumber) {
        super(requestType, username, project, projectFullName, buildNumber);
    }

    @Override
    public String getMessage() {
        return Messages.UnlockRequest_message(this.buildNumber + " for " + this.project);
    }

    @Override
    public boolean execute(Item item) {
        boolean success;
        block14: {
            Jenkins jenkins = null;
            success = false;
            String returnStatus = null;
            StringBuffer stringBuffer = new StringBuffer();
            String[] projectList = null;
            try {
                jenkins = Jenkins.get();
                if (jenkins == null) {
                    throw new NullPointerException("Jenkins instance is null");
                }
                if (Jenkins.get() != null && Jenkins.get().hasPermission(Run.DELETE)) {
                    try {
                        String jenkinsURL = null;
                        try {
                            jenkinsURL = Jenkins.get().getRootUrl();
                            if (jenkinsURL == null) {
                                throw new NullPointerException("Jenkins instance is null");
                            }
                        }
                        catch (NullPointerException npe) {
                            LOGGER.log(Level.SEVERE, "[ERROR] Exception: " + npe);
                            return false;
                        }
                        if (!this.projectFullName.contains("/job/") && this.projectFullName.contains("/")) {
                            projectList = this.projectFullName.split("/");
                            int nameCount = projectList.length;
                            stringBuffer.append(projectList[0]);
                            for (int i = 1; i < nameCount; ++i) {
                                stringBuffer.append("/job/");
                                stringBuffer.append(projectList[i]);
                            }
                            this.projectFullName = stringBuffer.toString();
                        }
                        RequestsUtility requestsUtility = new RequestsUtility();
                        this.projectFullName = this.projectFullName.replace(" ", "%20");
                        String urlString = jenkinsURL + "job/" + this.projectFullName + "/" + this.buildNumber + "/toggleLogKeep";
                        try {
                            returnStatus = requestsUtility.runPostMethod(jenkinsURL, urlString);
                            if (!returnStatus.equals("success")) {
                                this.errorMessage = "Unlock Build call has failed for " + this.projectFullName + ":" + this.buildNumber + " : " + returnStatus;
                                LOGGER.log(Level.INFO, "Unlock Build call has failed: ", this.projectFullName + ":" + this.buildNumber + " : " + returnStatus);
                                return false;
                            }
                            this.errorMessage = "Build number " + this.buildNumber + " has been properly Unlocked for " + this.projectFullName;
                            LOGGER.log(Level.INFO, "Build {0} has been properly Unlocked", this.projectFullName + ":" + this.buildNumber);
                            success = true;
                            break block14;
                        }
                        catch (IOException e) {
                            this.errorMessage = e.getMessage();
                            LOGGER.log(Level.SEVERE, "Unable to Unlock the build " + this.projectFullName + ":" + this.buildNumber, e.getMessage());
                            return false;
                        }
                    }
                    catch (Exception e) {
                        this.errorMessage = e.getMessage();
                        LOGGER.log(Level.SEVERE, "Unable to Unlock the build " + this.projectFullName + ":" + this.buildNumber, e.getMessage());
                    }
                    break block14;
                }
                this.errorMessage = "The current user " + this.username + " does not have permission to Unlock the job";
                LOGGER.log(Level.FINE, "The current user {0} does not have permission to UNLOCK the job", new Object[]{this.username});
            }
            catch (NullPointerException npe) {
                LOGGER.log(Level.SEVERE, "[ERROR] Exception: " + npe);
                return false;
            }
        }
        return success;
    }
}

