/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.release.pipeline;

import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.model.AutoCompletionCandidates;
import hudson.model.BuildableItem;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.release.ReleaseWrapper;
import hudson.plugins.release.pipeline.Messages;
import hudson.plugins.release.pipeline.ReleaseStepExecution;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.util.StaplerReferer;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Restricted(value={NoExternalUse.class})
public class ReleaseStep
extends Step {
    private static final Logger LOGGER = Logger.getLogger(ReleaseStep.class.getName());
    @CheckForNull
    private String job;
    @Nonnull
    private List<ParameterValue> parameters;

    @DataBoundConstructor
    public ReleaseStep(String job) {
        this.job = StringUtils.trimToNull((String)job);
        this.parameters = new ArrayList<ParameterValue>();
    }

    @CheckForNull
    public String getJob() {
        return this.job;
    }

    @Restricted(value={NoExternalUse.class})
    public void setJob(String job) {
        this.job = StringUtils.trimToNull((String)job);
    }

    public List<ParameterValue> getParameters() {
        return this.parameters;
    }

    @DataBoundSetter
    public void setParameters(List<ParameterValue> parameters) {
        this.parameters = parameters == null ? new ArrayList<ParameterValue>() : parameters;
    }

    public StepExecution start(StepContext stepContext) throws Exception {
        return new ReleaseStepExecution(stepContext, this);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "release";
        }

        public String getDisplayName() {
            return Messages.ReleaseStep_DisplayName();
        }

        public Set<Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, TaskListener.class);
        }

        public Step newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JSONArray params;
            ReleaseStep step = (ReleaseStep)super.newInstance(req, formData);
            String jobFullName = step.getJob();
            if (jobFullName == null) {
                throw new Descriptor.FormException("Job name is not specified or blank", "job");
            }
            Object parameter = formData.get("parameter");
            JSONArray jSONArray = params = parameter != null ? JSONArray.fromObject((Object)parameter) : null;
            if (params != null) {
                BuildableItem project = (BuildableItem)Jenkins.getActiveInstance().getItemByFullName(jobFullName, BuildableItem.class);
                if (project == null) {
                    throw new Descriptor.FormException("Can't find buildable item " + jobFullName, "job");
                }
                if (project instanceof BuildableItemWithBuildWrappers) {
                    ReleaseWrapper wrapper = (ReleaseWrapper)((BuildableItemWithBuildWrappers)project).getBuildWrappersList().get(ReleaseWrapper.class);
                    if (wrapper == null) {
                        throw new Descriptor.FormException("Job doesn't have the Release plugin configuration", "job");
                    }
                    List<ParameterDefinition> parameterDefinitions = wrapper.getParameterDefinitions();
                    if (parameterDefinitions != null) {
                        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
                        for (Object o : params) {
                            if (!(o instanceof JSONObject)) continue;
                            JSONObject jo = (JSONObject)o;
                            String name = jo.getString("name");
                            for (ParameterDefinition pd : parameterDefinitions) {
                                if (!name.equals(pd.getName())) continue;
                                ParameterValue parameterValue = pd.createValue(req, jo);
                                values.add(parameterValue);
                            }
                        }
                        step.setParameters(values);
                    }
                } else {
                    throw new Descriptor.FormException("The job is not an instance of the BuildableItemWithBuildWrappers class: " + project.getClass().getName(), "job");
                }
            }
            return step;
        }

        public AutoCompletionCandidates doAutoCompleteJob(@AncestorInPath ItemGroup<?> context, @QueryParameter String value) {
            return AutoCompletionCandidates.ofJobNames(ParameterizedJobMixIn.ParameterizedJob.class, (String)value, context);
        }

        @Restricted(value={DoNotUse.class})
        public String getContext() {
            Job job = (Job)StaplerReferer.findItemFromRequest(Job.class);
            return job != null ? job.getFullName() : null;
        }
    }
}

