/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.release.pipeline;

import hudson.AbortException;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.release.ReleaseWrapper;
import hudson.plugins.release.SafeParametersAction;
import hudson.plugins.release.pipeline.ReleaseStep;
import hudson.plugins.release.pipeline.ReleaseTriggerAction;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class ReleaseStepExecution
extends StepExecution {
    private static final Logger LOGGER = Logger.getLogger(ReleaseStepExecution.class.getName());
    transient ReleaseStep step;
    private static final long serialVersionUID = 1L;

    public ReleaseStepExecution(@Nonnull StepContext context, @Nonnull ReleaseStep step) {
        super(context);
        this.step = step;
    }

    private List<ParameterValue> updateParametersWithDefaults(ParameterizedJobMixIn.ParameterizedJob project, List<ParameterValue> parameters) throws AbortException {
        if (project instanceof BuildableItemWithBuildWrappers) {
            ReleaseWrapper wrapper = (ReleaseWrapper)((BuildableItemWithBuildWrappers)project).getBuildWrappersList().get(ReleaseWrapper.class);
            if (wrapper != null) {
                for (ParameterDefinition pd : wrapper.getParameterDefinitions()) {
                    boolean parameterExists = false;
                    for (ParameterValue pv : parameters) {
                        if (!pv.getName().equals(pd.getName())) continue;
                        parameterExists = true;
                        break;
                    }
                    if (parameterExists) continue;
                    parameters.add(pd.getDefaultParameterValue());
                }
            } else {
                throw new AbortException("Job doesn't have the Release plugin configuration");
            }
        }
        return parameters;
    }

    public boolean start() throws Exception {
        Queue.Item item;
        String jobFullName = this.step.getJob();
        if (jobFullName == null) {
            throw new AbortException("Job name is not defined.");
        }
        Item itemToRun = Jenkins.getActiveInstance().getItemByFullName(jobFullName);
        if (itemToRun == null) {
            throw new AbortException("No item found: " + jobFullName);
        }
        if (!(itemToRun instanceof Job) || !(itemToRun instanceof ParameterizedJobMixIn.ParameterizedJob)) {
            throw new AbortException("The specified item is not a parameterizable job: " + jobFullName);
        }
        ParameterizedJobMixIn.ParameterizedJob jobToRun = (ParameterizedJobMixIn.ParameterizedJob)itemToRun;
        this.println("Releasing job: " + ModelHyperlinkNote.encodeTo((Item)jobToRun));
        LOGGER.log(Level.FINER, "Scheduling release of {0} from {1}", new Object[]{jobToRun, this.getContext()});
        Run run = (Run)this.getContext().get(Run.class);
        ArrayList<Object> actions = new ArrayList<Object>(3);
        actions.add((Object)new ReleaseTriggerAction(this.getContext()));
        actions.add(new ReleaseWrapper.ReleaseBuildBadgeAction());
        actions.add((Object)new SafeParametersAction(this.updateParametersWithDefaults(jobToRun, this.step.getParameters())));
        if (run != null) {
            actions.add(new CauseAction((Cause)new Cause.UpstreamCause(run)));
        }
        if ((item = ParameterizedJobMixIn.scheduleBuild2((Job)((Job)jobToRun), (int)0, (Action[])actions.toArray(new Action[0]))) == null || item.getFuture() == null) {
            throw new AbortException("Failed to trigger build of " + jobToRun.getFullName());
        }
        return false;
    }

    private void println(String message) throws IOException, InterruptedException {
        TaskListener taskListener = (TaskListener)this.getContext().get(TaskListener.class);
        if (taskListener == null) {
            return;
        }
        PrintStream taskLogger = taskListener.getLogger();
        taskLogger.println(message);
    }

    public void stop(@Nonnull Throwable cause) throws Exception {
        this.getContext().onFailure(cause);
    }
}

