/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.release;

import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Launcher;
import hudson.Util;
import hudson.ivy.IvyModuleSet;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixChildAction;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.maven.MavenModuleSet;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildBadgeAction;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.PermalinkProjectAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.plugins.release.Messages;
import hudson.plugins.release.SafeParametersAction;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.ArrayUtils;
import org.jenkinsci.plugins.jobgenerator.JobGenerator;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ReleaseWrapper
extends BuildWrapper
implements MatrixAggregatable {
    public static final PermissionGroup PERMISSIONS = new PermissionGroup(ReleaseWrapper.class, Messages._ReleaseWrapper_PermissionsTitle());
    public static final Permission RELEASE_PERMISSION = new Permission(PERMISSIONS, "Release", Messages._ReleaseWrapper_ReleasePermission_Description(), Jenkins.ADMINISTER, PermissionScope.ITEM);
    private static final String DEFAULT_RELEASE_VERSION_TEMPLATE = "Release #$RELEASE_VERSION";
    private String releaseVersionTemplate;
    private boolean doNotKeepLog;
    private boolean overrideBuildParameters;
    private List<ParameterDefinition> parameterDefinitions = new ArrayList<ParameterDefinition>();
    private List<BuildStep> preBuildSteps = new ArrayList<BuildStep>();
    private List<BuildStep> postBuildSteps = new ArrayList<BuildStep>();
    private List<BuildStep> postSuccessfulBuildSteps = new ArrayList<BuildStep>();
    private List<BuildStep> postFailedBuildSteps = new ArrayList<BuildStep>();
    private List<BuildStep> preMatrixBuildSteps = new ArrayList<BuildStep>();
    private List<BuildStep> postSuccessfulMatrixBuildSteps = new ArrayList<BuildStep>();
    private List<BuildStep> postFailedMatrixBuildSteps = new ArrayList<BuildStep>();
    private List<BuildStep> postMatrixBuildSteps = new ArrayList<BuildStep>();
    public static final List<PermalinkProjectAction.Permalink> RELEASE = new CopyOnWriteArrayList<PermalinkProjectAction.Permalink>();

    public String getReleaseVersionTemplate() {
        return this.releaseVersionTemplate;
    }

    public void setReleaseVersionTemplate(String releaseVersionTemplate) {
        this.releaseVersionTemplate = releaseVersionTemplate;
    }

    public boolean isDoNotKeepLog() {
        return this.doNotKeepLog;
    }

    public void setDoNotKeepLog(boolean doNotKeepLog) {
        this.doNotKeepLog = doNotKeepLog;
    }

    public boolean isOverrideBuildParameters() {
        return this.overrideBuildParameters;
    }

    public void setOverrideBuildParameters(boolean overrideBuildParameters) {
        this.overrideBuildParameters = overrideBuildParameters;
    }

    public List<ParameterDefinition> getParameterDefinitions() {
        return this.parameterDefinitions;
    }

    public void setParameterDefinitions(List<ParameterDefinition> parameterDefinitions) {
        this.parameterDefinitions = parameterDefinitions;
    }

    public List<BuildStep> getPreBuildSteps() {
        return this.preBuildSteps;
    }

    public void setPreBuildSteps(List<BuildStep> preBuildSteps) {
        this.preBuildSteps = preBuildSteps;
    }

    public List<BuildStep> getPreMatrixBuildSteps() {
        return this.preMatrixBuildSteps;
    }

    public void setPreMatrixBuildSteps(List<BuildStep> preMatrixBuildSteps) {
        this.preMatrixBuildSteps = preMatrixBuildSteps;
    }

    public List<BuildStep> getPostBuildSteps() {
        return this.postBuildSteps;
    }

    public void setPostBuildSteps(List<BuildStep> postSuccessBuildSteps) {
        this.postBuildSteps = postSuccessBuildSteps;
    }

    public List<BuildStep> getPostMatrixBuildSteps() {
        return this.postMatrixBuildSteps;
    }

    public void setPostMatrixBuildSteps(List<BuildStep> postMatrixBuildSteps) {
        this.postMatrixBuildSteps = postMatrixBuildSteps;
    }

    public List<BuildStep> getPostSuccessfulBuildSteps() {
        return this.postSuccessfulBuildSteps;
    }

    public void setPostSuccessfulBuildSteps(List<BuildStep> postSuccessfulBuildSteps) {
        this.postSuccessfulBuildSteps = postSuccessfulBuildSteps;
    }

    public List<BuildStep> getPostFailedBuildSteps() {
        return this.postFailedBuildSteps;
    }

    public void setPostFailedBuildSteps(List<BuildStep> postFailedBuildSteps) {
        this.postFailedBuildSteps = postFailedBuildSteps;
    }

    public List<BuildStep> getPostSuccessfulMatrixBuildSteps() {
        return this.postSuccessfulMatrixBuildSteps;
    }

    public void setPostSuccessfulMatrixBuildSteps(List<BuildStep> postSuccessfulMatrixBuildSteps) {
        this.postSuccessfulMatrixBuildSteps = postSuccessfulMatrixBuildSteps;
    }

    public List<BuildStep> getPostFailedMatrixBuildSteps() {
        return this.postFailedMatrixBuildSteps;
    }

    public void setPostFailedMatrixBuildSteps(List<BuildStep> postFailedMatrixBuildSteps) {
        this.postFailedMatrixBuildSteps = postFailedMatrixBuildSteps;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject job) {
        return Collections.singletonList(new ReleaseAction(job));
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        ReleaseAggregator instance = new ReleaseAggregator(build, launcher, listener);
        instance.setPreMatrixBuildSteps(this.preMatrixBuildSteps);
        instance.setPostSuccessfulMatrixBuildSteps(this.postSuccessfulMatrixBuildSteps);
        instance.setPostFailedMatrixBuildSteps(this.postFailedMatrixBuildSteps);
        instance.setPostMatrixBuildSteps(this.postMatrixBuildSteps);
        return instance;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, final Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        final ReleaseBuildBadgeAction releaseBuildBadge = (ReleaseBuildBadgeAction)build.getAction(ReleaseBuildBadgeAction.class);
        if (releaseBuildBadge == null) {
            return new BuildWrapper.Environment(){};
        }
        ParametersAction parametersAction = (ParametersAction)build.getAction(ParametersAction.class);
        if (parametersAction != null) {
            VariableResolver<String> resolver = this.createVariableResolver(parametersAction, build);
            String releaseVersion = Util.replaceMacro((String)(this.releaseVersionTemplate != null && !"".equals(this.releaseVersionTemplate) ? this.releaseVersionTemplate : DEFAULT_RELEASE_VERSION_TEMPLATE), resolver);
            EnvVars env = build.getEnvironment((TaskListener)listener);
            releaseVersion = env.expand(releaseVersion);
            if (DEFAULT_RELEASE_VERSION_TEMPLATE.equals(releaseVersion)) {
                releaseVersion = null;
            }
            releaseBuildBadge.releaseVersion = releaseVersion;
        }
        if (!this.executeBuildSteps(this.preBuildSteps, build, launcher, listener)) {
            throw new IOException(Messages.ReleaseWrapper_CouldNotExecutePreBuildSteps());
        }
        return new BuildWrapper.Environment(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                boolean shouldContinue = false;
                try {
                    Result result = build.getResult();
                    if (result == null || result.isBetterOrEqualTo(Result.UNSTABLE)) {
                        if (!ReleaseWrapper.this.doNotKeepLog) {
                            build.keepLog();
                        }
                        if (releaseBuildBadge.getReleaseVersion() != null) {
                            build.setDescription(releaseBuildBadge.getReleaseVersion());
                            if (build instanceof MatrixRun) {
                                ((MatrixRun)build).getParentBuild().setDescription(releaseBuildBadge.getReleaseVersion());
                            }
                        }
                        shouldContinue = ReleaseWrapper.this.executeBuildSteps(ReleaseWrapper.this.postSuccessfulBuildSteps, build, launcher, listener);
                    } else {
                        shouldContinue = ReleaseWrapper.this.executeBuildSteps(ReleaseWrapper.this.postFailedBuildSteps, build, launcher, listener);
                    }
                }
                finally {
                    if (shouldContinue) {
                        shouldContinue = ReleaseWrapper.this.executeBuildSteps(ReleaseWrapper.this.postBuildSteps, build, launcher, listener);
                    }
                }
                return shouldContinue;
            }
        };
    }

    private VariableResolver<String> createVariableResolver(ParametersAction parametersAction, AbstractBuild<?, ?> build) {
        Object[] resolvers = new VariableResolver[parametersAction.getParameters().size() + 1];
        int i = 0;
        for (ParameterValue p : parametersAction.getParameters()) {
            resolvers[i++] = p.createVariableResolver(build);
        }
        resolvers[i] = build.getBuildVariableResolver();
        ArrayUtils.reverse((Object[])resolvers);
        return new VariableResolver.Union((VariableResolver[])resolvers);
    }

    private boolean executeBuildSteps(List<BuildStep> buildSteps, AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean shouldContinue = true;
        if (buildSteps != null) {
            for (BuildStep buildStep : buildSteps) {
                if (!shouldContinue) break;
                shouldContinue = buildStep.prebuild(build, listener);
            }
            for (BuildStep buildStep : buildSteps) {
                if (!shouldContinue) break;
                shouldContinue = buildStep.perform(build, launcher, listener);
            }
        }
        return shouldContinue;
    }

    public static boolean hasReleasePermission(AbstractProject job) {
        return job.hasPermission(RELEASE_PERMISSION) && !MatrixConfiguration.class.isInstance(job);
    }

    public static void checkReleasePermission(AbstractProject job) {
        job.checkPermission(RELEASE_PERMISSION);
    }

    static {
        RELEASE.add(new PermalinkProjectAction.Permalink(){

            public String getDisplayName() {
                return Messages.ReleaseWrapper_LastReleaseBuild();
            }

            public String getId() {
                return "lastReleaseBuild";
            }

            public Run<?, ?> resolve(Job<?, ?> job) {
                for (Run build : job.getBuilds()) {
                    if (build.getAction(ReleaseBuildBadgeAction.class) == null) continue;
                    return build;
                }
                return null;
            }
        });
        RELEASE.add(new PermalinkProjectAction.Permalink(){

            public String getDisplayName() {
                return Messages.ReleaseWrapper_LastSuccessfulReleaseBuild();
            }

            public String getId() {
                return "lastSuccessfulReleaseBuild";
            }

            public Run<?, ?> resolve(Job<?, ?> job) {
                for (Run build : job.getBuilds()) {
                    if (build.getResult() != Result.SUCCESS || build.getAction(ReleaseBuildBadgeAction.class) == null) continue;
                    return build;
                }
                return null;
            }
        });
    }

    public static class ReleaseAggregator
    extends MatrixAggregator {
        private List<BuildStep> preMatrixBuildSteps = new ArrayList<BuildStep>();
        private List<BuildStep> postSuccessfulMatrixBuildSteps = new ArrayList<BuildStep>();
        private List<BuildStep> postFailedMatrixBuildSteps = new ArrayList<BuildStep>();
        private List<BuildStep> postMatrixBuildSteps = new ArrayList<BuildStep>();
        private boolean isNotRelease = true;

        public ReleaseAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
            super(build, launcher, listener);
            this.isNotRelease = build.getAction(ReleaseBuildBadgeAction.class) == null;
        }

        public void setPreMatrixBuildSteps(List<BuildStep> preMatrixBuildSteps) {
            this.preMatrixBuildSteps = preMatrixBuildSteps;
        }

        public void setPostMatrixBuildSteps(List<BuildStep> postMatrixBuildSteps) {
            this.postMatrixBuildSteps = postMatrixBuildSteps;
        }

        public void setPostSuccessfulMatrixBuildSteps(List<BuildStep> postSuccessfulMatrixBuildSteps) {
            this.postSuccessfulMatrixBuildSteps = postSuccessfulMatrixBuildSteps;
        }

        public void setPostFailedMatrixBuildSteps(List<BuildStep> postFailedMatrixBuildSteps) {
            this.postFailedMatrixBuildSteps = postFailedMatrixBuildSteps;
        }

        public boolean startBuild() throws InterruptedException, IOException {
            if (this.isNotRelease) {
                return true;
            }
            return this.executeBuildSteps(this.preMatrixBuildSteps, (AbstractBuild)this.build, this.launcher, this.listener);
        }

        public boolean endBuild() throws InterruptedException, IOException {
            if (this.isNotRelease) {
                return true;
            }
            boolean shouldContinue = true;
            try {
                Result result = this.build.getResult();
                shouldContinue = result == null || result.isBetterOrEqualTo(Result.UNSTABLE) ? this.executeBuildSteps(this.postSuccessfulMatrixBuildSteps, (AbstractBuild)this.build, this.launcher, this.listener) : this.executeBuildSteps(this.postFailedMatrixBuildSteps, (AbstractBuild)this.build, this.launcher, this.listener);
            }
            finally {
                if (shouldContinue) {
                    shouldContinue = this.executeBuildSteps(this.postMatrixBuildSteps, (AbstractBuild)this.build, this.launcher, this.listener);
                }
            }
            return shouldContinue;
        }

        private boolean executeBuildSteps(List<BuildStep> buildSteps, AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
            boolean shouldContinue = true;
            if (buildSteps != null) {
                for (BuildStep buildStep : buildSteps) {
                    if (!shouldContinue) break;
                    shouldContinue = buildStep.prebuild(build, listener);
                }
                for (BuildStep buildStep : buildSteps) {
                    if (!shouldContinue) break;
                    shouldContinue = buildStep.perform(build, launcher, listener);
                }
            }
            return shouldContinue;
        }
    }

    public static class ReleaseBuildBadgeAction
    implements BuildBadgeAction,
    MatrixChildAction {
        private String releaseVersion;

        public String getReleaseVersion() {
            return this.releaseVersion;
        }

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public String getUrlName() {
            return null;
        }
    }

    public class ReleaseAction
    implements Action,
    PermalinkProjectAction {
        private AbstractProject project;
        private String releaseVersion;
        private String developmentVersion;

        public ReleaseAction(AbstractProject project) {
            this.project = project;
        }

        public List<ParameterDefinition> getParameterDefinitions() {
            return ReleaseWrapper.this.parameterDefinitions;
        }

        public List<ParameterDefinition> getBuildParameterDefinitions() {
            ParametersDefinitionProperty paramsDefProp = (ParametersDefinitionProperty)this.project.getProperty(ParametersDefinitionProperty.class);
            if (paramsDefProp != null) {
                return paramsDefProp.getParameterDefinitions();
            }
            return null;
        }

        public String getDisplayName() {
            return "Release";
        }

        public String getIconFileName() {
            return this.project.isBuildable() && ReleaseWrapper.hasReleasePermission(this.project) ? "package.png" : null;
        }

        public String getUrlName() {
            return "release";
        }

        public AbstractProject getProject() {
            return this.project;
        }

        public List<AbstractBuild> getPreviousReleaseBuilds() {
            ArrayList<AbstractBuild> previousReleaseBuilds = new ArrayList<AbstractBuild>();
            for (AbstractBuild build : this.project.getBuilds()) {
                ReleaseBuildBadgeAction badge = (ReleaseBuildBadgeAction)build.getAction(ReleaseBuildBadgeAction.class);
                if (badge == null) continue;
                previousReleaseBuilds.add(build);
            }
            return previousReleaseBuilds;
        }

        public String getReleaseVersionForBuild(AbstractBuild build) {
            ReleaseBuildBadgeAction badge = (ReleaseBuildBadgeAction)build.getAction(ReleaseBuildBadgeAction.class);
            return badge.getReleaseVersion();
        }

        public List<ParameterValue> getParametersForBuild(AbstractBuild build) {
            ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
            if (parameters != null) {
                return parameters.getParameters();
            }
            return Collections.emptyList();
        }

        public String getReleaseVersion() {
            return this.releaseVersion;
        }

        public void setReleaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
        }

        public String getDevelopmentVersion() {
            return this.developmentVersion;
        }

        public void setDevelopmentVersion(String developmentVersion) {
            this.developmentVersion = developmentVersion;
        }

        public ParameterDefinition getParameterDefinition(String name) {
            ParametersDefinitionProperty buildParamsDefProp = (ParametersDefinitionProperty)this.project.getProperty(ParametersDefinitionProperty.class);
            List buildParameterDefinitions = null;
            if (buildParamsDefProp != null) {
                buildParameterDefinitions = buildParamsDefProp.getParameterDefinitions();
            }
            if (!ReleaseWrapper.this.overrideBuildParameters && ReleaseWrapper.this.parameterDefinitions == null || ReleaseWrapper.this.overrideBuildParameters && ReleaseWrapper.this.parameterDefinitions == null && buildParameterDefinitions == null) {
                return null;
            }
            for (ParameterDefinition pd : ReleaseWrapper.this.parameterDefinitions) {
                if (!pd.getName().equals(name)) continue;
                return pd;
            }
            if (ReleaseWrapper.this.overrideBuildParameters) {
                for (ParameterDefinition pd : buildParameterDefinitions) {
                    if (!pd.getName().equals(name)) continue;
                    return pd;
                }
            }
            return null;
        }

        private List<ParameterValue> getDefaultParametersValues() {
            ParametersDefinitionProperty paramDefProp = (ParametersDefinitionProperty)this.project.getProperty(ParametersDefinitionProperty.class);
            ArrayList<ParameterValue> defValues = new ArrayList<ParameterValue>();
            if (paramDefProp == null) {
                return defValues;
            }
            for (ParameterDefinition paramDefinition : paramDefProp.getParameterDefinitions()) {
                ParameterValue defaultValue = paramDefinition.getDefaultParameterValue();
                if (defaultValue == null) continue;
                defValues.add(defaultValue);
            }
            return defValues;
        }

        public boolean isOverrideBuildParameters() {
            return ReleaseWrapper.this.overrideBuildParameters;
        }

        @RequirePOST
        public void doSubmit(StaplerRequest req, StaplerResponse resp) throws IOException, ServletException {
            ReleaseWrapper.checkReleasePermission(this.project);
            req.bindParameters((Object)this);
            List<ParameterValue> paramValues = this.isOverrideBuildParameters() ? new ArrayList<ParameterValue>() : this.getDefaultParametersValues();
            if (this.getParameterDefinitions() != null && !this.getParameterDefinitions().isEmpty() || ReleaseWrapper.this.overrideBuildParameters && this.getBuildParameterDefinitions() != null && !this.getBuildParameterDefinitions().isEmpty()) {
                JSONObject formData = req.getSubmittedForm();
                JSONArray a = JSONArray.fromObject((Object)formData.get("parameter"));
                for (Object o : a) {
                    JSONObject jo = (JSONObject)o;
                    String name = jo.getString("name");
                    ParameterDefinition d = this.getParameterDefinition(name);
                    if (d == null) {
                        throw new IllegalArgumentException("No such parameter definition: " + name);
                    }
                    ParameterValue value = d.createValue(req, jo);
                    paramValues.add(d.createValue(req, jo));
                }
            } else {
                if (this.releaseVersion != null && !"".equals(this.releaseVersion)) {
                    paramValues.add((ParameterValue)new StringParameterValue("RELEASE_VERSION", this.releaseVersion));
                }
                if (this.developmentVersion != null && !"".equals(this.developmentVersion)) {
                    paramValues.add((ParameterValue)new StringParameterValue("DEVELOPMENT_VERSION", this.developmentVersion));
                }
            }
            if (!this.project.scheduleBuild(0, (Cause)new Cause.UserIdCause(), new Action[]{new ReleaseBuildBadgeAction(), new SafeParametersAction(paramValues)})) {
                // empty if block
            }
            resp.sendRedirect(this.project.getAbsoluteUrl());
        }

        public List<PermalinkProjectAction.Permalink> getPermalinks() {
            return RELEASE;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return Messages.ReleaseWrapper_ConfigureReleaseBuild();
        }

        public BuildWrapper newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            ReleaseWrapper instance = new ReleaseWrapper();
            instance.releaseVersionTemplate = formData.getString("releaseVersionTemplate");
            instance.doNotKeepLog = formData.getBoolean("doNotKeepLog");
            instance.overrideBuildParameters = formData.getBoolean("overrideBuildParameters");
            instance.parameterDefinitions = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"parameters", (Collection)ParameterDefinition.all());
            instance.preBuildSteps = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"preBuildSteps", (Collection)this.getSteps());
            instance.preMatrixBuildSteps = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"preMatrixBuildSteps", (Collection)this.getSteps());
            instance.postBuildSteps = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"postBuildSteps", (Collection)this.getSteps());
            instance.postSuccessfulBuildSteps = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"postSuccessfulBuildSteps", (Collection)this.getSteps());
            instance.postFailedBuildSteps = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"postFailedBuildSteps", (Collection)this.getSteps());
            instance.postMatrixBuildSteps = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"postMatrixBuildSteps", (Collection)this.getSteps());
            instance.postSuccessfulMatrixBuildSteps = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"postSuccessfulMatrixBuildSteps", (Collection)this.getSteps());
            instance.postFailedMatrixBuildSteps = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"postFailedMatrixBuildSteps", (Collection)this.getSteps());
            return instance;
        }

        private ExtensionList getSteps() {
            DescriptorExtensionList publishers = DescriptorExtensionList.createDescriptorList((Jenkins)Jenkins.getInstance(), Publisher.class);
            DescriptorExtensionList builders = DescriptorExtensionList.createDescriptorList((Jenkins)Jenkins.getInstance(), Builder.class);
            ExtensionListImpl impl = new ExtensionListImpl();
            impl.addAll((Collection)publishers);
            impl.addAll((Collection)builders);
            return impl;
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return FreeStyleProject.class.isInstance(item) || MavenModuleSet.class.isInstance(item) || MatrixProject.class.isInstance(item) || this.isApplicableFor3rdParty(item);
        }

        private boolean isApplicableFor3rdParty(AbstractProject<?, ?> item) {
            boolean isApplicable = false;
            Jenkins jenkinsInstance = Jenkins.getInstance();
            if (jenkinsInstance != null) {
                if (jenkinsInstance.getPlugin("ivy") != null) {
                    isApplicable = IvyModuleSet.class.isInstance(item);
                }
                if (jenkinsInstance.getPlugin("jobgenerator") != null) {
                    isApplicable |= JobGenerator.class.isInstance(item);
                }
            }
            return isApplicable;
        }

        public boolean isMatrixProject(AbstractProject<?, ?> item) {
            return MatrixProject.class.isInstance(item);
        }

        private static class ExtensionListImpl
        extends ExtensionList<Descriptor> {
            public ExtensionListImpl() {
                super(Jenkins.getInstance(), Descriptor.class);
            }
        }
    }
}

