/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.releaseplugin.influxdb;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.ItemGroup;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.text.StrSubstitutor;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import rocks.inspectit.releaseplugin.influxdb.InfluxContentParser;

public class InfluxDBPublisher
extends Builder {
    private String userCredentialsID;
    private String dbUrl;
    private String dbName;
    private String content;

    @DataBoundConstructor
    public InfluxDBPublisher(String userCredentialsID, String dbUrl, String dbName, String content) {
        this.userCredentialsID = userCredentialsID;
        this.dbUrl = dbUrl;
        this.dbName = dbName;
        this.content = content;
    }

    public String getUserCredentialsID() {
        return this.userCredentialsID;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getContent() {
        return this.content;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        StrSubstitutor varReplacer = this.getVariablesSubstitutor(build, listener);
        PrintStream logger = listener.getLogger();
        UsernamePasswordCredentials cred = (UsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM), (CredentialsMatcher)CredentialsMatchers.withId((String)this.userCredentialsID));
        String dbUrl = varReplacer.replace(this.dbUrl);
        String dbName = varReplacer.replace(this.dbName);
        String content = varReplacer.replace(this.content);
        InfluxDB influx = InfluxDBFactory.connect((String)dbUrl, (String)cred.getUsername(), (String)cred.getPassword().getPlainText());
        BatchPoints batchPoints = BatchPoints.database((String)dbName).retentionPolicy("default").consistency(InfluxDB.ConsistencyLevel.ALL).build();
        List<InfluxContentParser.ContentLine> contentLines = InfluxContentParser.parse(content);
        logger.println("Publishing " + contentLines.size() + " to InfluxDB at " + dbUrl);
        for (InfluxContentParser.ContentLine cl : contentLines) {
            Point.Builder builder = Point.measurement((String)cl.getMeasurementName()).tag(cl.getTags()).fields(cl.getFields());
            if (cl.getTimestamp() != null) {
                builder.time(cl.getTimestamp().longValue(), TimeUnit.NANOSECONDS);
            }
            Point point = builder.build();
            batchPoints.point(point);
        }
        influx.write(batchPoints);
        return true;
    }

    protected StrSubstitutor getVariablesSubstitutor(AbstractBuild<?, ?> build, BuildListener lis) {
        EnvVars env;
        ParametersAction params = (ParametersAction)build.getAction(ParametersAction.class);
        HashMap variables = new HashMap();
        try {
            env = build.getEnvironment((TaskListener)lis);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry en : env.entrySet()) {
            variables.put(en.getKey(), en.getValue());
        }
        if (params != null) {
            for (ParameterValue val : params.getParameters()) {
                variables.put(val.getName(), val.getValue().toString());
            }
        }
        StrSubstitutor subs = new StrSubstitutor(variables);
        return subs;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "InfluxDB Publisher";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public ListBoxModel doFillUserCredentialsIDItems(@AncestorInPath ItemGroup<?> context) {
            if (!(context instanceof AccessControlled ? (AccessControlled)context : Jenkins.getInstance()).hasPermission(Computer.CONFIGURE)) {
                return new ListBoxModel();
            }
            return new StandardListBoxModel().withAll((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, context, (Authentication)ACL.SYSTEM));
        }
    }
}

