/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.releaseplugin;

import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.MetadataRestClient;
import com.atlassian.jira.rest.client.api.VersionRestClient;
import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.BasicIssueType;
import com.atlassian.jira.rest.client.api.domain.BasicPriority;
import com.atlassian.jira.rest.client.api.domain.BasicProject;
import com.atlassian.jira.rest.client.api.domain.Field;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.IssueType;
import com.atlassian.jira.rest.client.api.domain.Priority;
import com.atlassian.jira.rest.client.api.domain.Project;
import com.atlassian.jira.rest.client.api.domain.SearchResult;
import com.atlassian.jira.rest.client.api.domain.Transition;
import com.atlassian.jira.rest.client.api.domain.Version;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import com.atlassian.jira.rest.client.api.domain.input.TransitionInput;
import com.atlassian.jira.rest.client.api.domain.input.VersionInputBuilder;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import rocks.inspectit.releaseplugin.FieldMetadata;
import rocks.inspectit.releaseplugin.IssueUpdateBuilder;
import rocks.inspectit.releaseplugin.JsonHTTPClientWrapper;

public class JIRAAccessTool {
    private JiraRestClient restClient;
    String jenkinsCredentialsId;
    private String url;
    private String user;
    private String password;
    private String proxy;
    private String projectKey;
    private JsonHTTPClientWrapper jsonClient;

    public JIRAAccessTool(String url, String user, String password, String proxy, String projectKey, String jenkinsCredentialsId) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.proxy = proxy;
        this.projectKey = projectKey;
        this.jenkinsCredentialsId = jenkinsCredentialsId;
        this.connect();
    }

    public String getJenkinsCredentialsId() {
        return this.jenkinsCredentialsId;
    }

    public List<String> getAvailableIssueTypes() {
        ArrayList<String> names = new ArrayList<String>();
        for (IssueType type : (Iterable)this.restClient.getMetadataClient().getIssueTypes().claim()) {
            names.add(type.getName());
        }
        return names;
    }

    public List<String> getAvailableIssuePriorities() {
        ArrayList<String> names = new ArrayList<String>();
        for (Priority priority : (Iterable)this.restClient.getMetadataClient().getPriorities().claim()) {
            names.add(priority.getName());
        }
        return names;
    }

    public List<String> getAvailableIssueStatuses() {
        ArrayList<String> names = new ArrayList<String>();
        return names;
    }

    public List<String> getAvailableVersions() {
        ArrayList<String> names = new ArrayList<String>();
        Project project = (Project)this.restClient.getProjectClient().getProject(this.projectKey).claim();
        for (Version version : project.getVersions()) {
            names.add(version.getName());
        }
        return names;
    }

    private void connect() {
        this.jsonClient = new JsonHTTPClientWrapper(this.url, this.user, this.password, this.proxy);
        AsynchronousJiraRestClientFactory factory = new AsynchronousJiraRestClientFactory();
        this.restClient = factory.createWithBasicHttpAuthentication(URI.create(this.url), this.user, this.password);
    }

    public Version createUpdateVersion(String versionName, BuildingLambda<VersionInputBuilder> buildingLambda) {
        VersionRestClient cl = this.restClient.getVersionRestClient();
        Version existingVersion = this.getVersionByName(versionName);
        if (existingVersion == null) {
            VersionInputBuilder builder = new VersionInputBuilder(this.projectKey);
            builder.setName(versionName);
            existingVersion = (Version)cl.createVersion(builder.build()).claim();
        }
        VersionInputBuilder versBuilder = new VersionInputBuilder(this.projectKey);
        versBuilder.setArchived(existingVersion.isArchived());
        versBuilder.setName(versionName);
        versBuilder.setReleased(existingVersion.isReleased());
        buildingLambda.build(versBuilder);
        return (Version)cl.updateVersion(existingVersion.getSelf(), versBuilder.build()).claim();
    }

    public Version getVersionByName(String versionName) {
        Project project = (Project)this.restClient.getProjectClient().getProject(this.projectKey).claim();
        Version existingVersion = null;
        for (Version vers : project.getVersions()) {
            if (!vers.getName().equalsIgnoreCase(versionName)) continue;
            existingVersion = vers;
        }
        return existingVersion;
    }

    public List<Issue> getTicketsByVersion(Version version) {
        return this.getTicketsByJQL("affectedVersion = " + version.getName());
    }

    public List<Issue> getTicketsByJQL(String jqlQuery) {
        SearchResult result = (SearchResult)this.restClient.getSearchClient().searchJql("(" + jqlQuery + ") AND project = \"" + this.projectKey + "\"").claim();
        ArrayList<Issue> issues = new ArrayList<Issue>();
        for (Issue is : result.getIssues()) {
            issues.add(is);
        }
        return issues;
    }

    public String buildReleaseNotesHTML(List<Issue> issuesToShow) {
        HashSet<String> issueTypesSet = new HashSet<String>();
        for (Issue is : issuesToShow) {
            issueTypesSet.add(is.getIssueType().getName());
        }
        ArrayList sortedIssueTypes = new ArrayList(issueTypesSet);
        sortedIssueTypes.sort(String.CASE_INSENSITIVE_ORDER);
        String resultHtml = "";
        for (String issueType : sortedIssueTypes) {
            resultHtml = resultHtml + "<h2>" + issueType + "</h2>";
            resultHtml = resultHtml + "<ul>";
            for (Issue is : issuesToShow) {
                if (!is.getIssueType().getName().equals(issueType)) continue;
                resultHtml = resultHtml + "<li>[<a href='" + this.url + "/browse/" + is.getKey() + "'>" + is.getKey() + "</a>] - " + is.getSummary() + "</li>";
            }
            resultHtml = resultHtml + "</ul>";
        }
        return resultHtml;
    }

    public BasicIssue addTicket(BuildingLambda<IssueInputBuilder> buildingFunction, BasicIssueType type) {
        Project project = (Project)this.restClient.getProjectClient().getProject(this.projectKey).claim();
        IssueInputBuilder builder = new IssueInputBuilder((BasicProject)project, type);
        buildingFunction.build(builder);
        return (BasicIssue)this.restClient.getIssueClient().createIssue(builder.build()).claim();
    }

    public void updateTicket(String ticketKey, BuildingLambda<IssueUpdateBuilder> updatingFunction) {
        IssueUpdateBuilder builder = new IssueUpdateBuilder();
        updatingFunction.build(builder);
        this.jsonClient.putJson("/rest/api/2/issue/" + ticketKey, builder.getRequestData());
    }

    public IssueType getIssueTypeByName(String typeName) {
        MetadataRestClient metadata = this.restClient.getMetadataClient();
        IssueType type = null;
        for (IssueType type2 : (Iterable)metadata.getIssueTypes().claim()) {
            if (!type2.getName().equalsIgnoreCase(typeName)) continue;
            type = type2;
        }
        return type;
    }

    public BasicPriority getIssuePriorityByName(String priorityName) {
        MetadataRestClient metadata = this.restClient.getMetadataClient();
        BasicPriority prio = null;
        for (BasicPriority prio2 : (Iterable)metadata.getPriorities().claim()) {
            if (!prio2.getName().equalsIgnoreCase(priorityName)) continue;
            prio = prio2;
        }
        return prio;
    }

    public void destroy() {
        try {
            this.restClient.close();
            this.jsonClient.destroy();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Issue getTicketByKey(String ticketKey) {
        return (Issue)this.restClient.getIssueClient().getIssue(ticketKey).claim();
    }

    public Iterable<Transition> getAvailableTransitions(Issue issue) {
        return (Iterable)this.restClient.getIssueClient().getTransitions(issue).claim();
    }

    public void performTransition(Issue issue, TransitionInput transition) {
        this.restClient.getIssueClient().transition(issue, transition).claim();
    }

    public List<FieldMetadata> getAvailableFields() {
        ArrayList<FieldMetadata> result = new ArrayList<FieldMetadata>();
        for (Field f : (Iterable)this.restClient.getMetadataClient().getFields().claim()) {
            result.add(new FieldMetadata(f));
        }
        return result;
    }

    public static interface BuildingLambda<B> {
        public void build(B var1);
    }
}

