/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.releaseplugin.versioning;

import com.atlassian.jira.rest.client.api.domain.input.VersionInputBuilder;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.io.PrintStream;
import org.apache.commons.lang.text.StrSubstitutor;
import org.joda.time.DateTime;
import org.kohsuke.stapler.DataBoundConstructor;
import rocks.inspectit.releaseplugin.JIRAAccessTool;

public class ModifyAddVersionTemplate
extends AbstractDescribableImpl<ModifyAddVersionTemplate> {
    private String versionName;
    private boolean replaceDescription;
    private String descriptionText;
    private String releaseState;
    private boolean failOnJQL;
    private String failQuery;

    @DataBoundConstructor
    public ModifyAddVersionTemplate(String versionName, boolean replaceDescription, String descriptionText, String releaseState, boolean failOnJQL, String failQuery) {
        this.versionName = versionName;
        this.replaceDescription = replaceDescription;
        this.descriptionText = descriptionText;
        this.releaseState = releaseState;
        this.failOnJQL = failOnJQL;
        this.failQuery = failQuery;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public boolean isReplaceDescription() {
        return this.replaceDescription;
    }

    public String getDescriptionText() {
        return this.descriptionText;
    }

    public String getReleaseState() {
        return this.releaseState;
    }

    public boolean isFailOnJQL() {
        return this.failOnJQL;
    }

    public String getFailQuery() {
        return this.failQuery;
    }

    public void applyModifications(final JIRAAccessTool jira, StrSubstitutor varReplacer, PrintStream logger) {
        final String versionName = varReplacer.replace(this.versionName);
        final String descriptionText = varReplacer.replace(this.descriptionText);
        final String failQuery = varReplacer.replace(this.failQuery);
        logger.println("Updating / Creating version " + versionName);
        jira.createUpdateVersion(versionName, new JIRAAccessTool.BuildingLambda<VersionInputBuilder>(){

            @Override
            public void build(VersionInputBuilder b) {
                if (ModifyAddVersionTemplate.this.replaceDescription) {
                    b.setDescription(descriptionText);
                }
                if (ModifyAddVersionTemplate.this.releaseState.equals("unreleased")) {
                    b.setReleased(false);
                } else if (ModifyAddVersionTemplate.this.releaseState.equals("released")) {
                    String jql;
                    long numberOfOpenTickets;
                    b.setReleased(true);
                    b.setReleaseDate(new DateTime());
                    if (ModifyAddVersionTemplate.this.failOnJQL && (numberOfOpenTickets = jira.getTicketsByJQL(jql = "affectedVersion=\"" + versionName + "\" AND (" + failQuery + ")").stream().count()) > 0L) {
                        throw new RuntimeException("Unable to release version " + versionName + ", because there are still " + numberOfOpenTickets + " matching the query '" + jql + "'");
                    }
                }
            }
        });
    }

    @Extension
    public static class DescribtorImpl
    extends Descriptor<ModifyAddVersionTemplate> {
        public String getDisplayName() {
            return "Add / Modify JIRA Project Version";
        }
    }
}

