/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.releaseplugin.ticketing;

import hudson.Extension;
import hudson.RelativePath;
import hudson.model.Descriptor;
import hudson.util.ComboBoxModel;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.text.StrSubstitutor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import rocks.inspectit.releaseplugin.FieldMetadata;
import rocks.inspectit.releaseplugin.IssueUpdateBuilder;
import rocks.inspectit.releaseplugin.JIRAAccessTool;
import rocks.inspectit.releaseplugin.JIRAMetadataCache;
import rocks.inspectit.releaseplugin.ticketing.TicketModification;

public class SetFieldModification
extends TicketModification {
    private String fieldHumanReadableName;
    private String valueToSet;

    @DataBoundConstructor
    public SetFieldModification(String fieldHumanReadableName, String valueToSet) {
        this.fieldHumanReadableName = fieldHumanReadableName;
        this.valueToSet = valueToSet;
    }

    public String getFieldHumanReadableName() {
        return this.fieldHumanReadableName;
    }

    public String getValueToSet() {
        return this.valueToSet;
    }

    @Override
    public void apply(String ticketKey, JIRAAccessTool jira, final StrSubstitutor varReplacer, PrintStream logger) {
        List<FieldMetadata> fields = JIRAMetadataCache.getSingleton().getFieldMetadata(jira.getJenkinsCredentialsId());
        String fieldName = varReplacer.replace(this.fieldHumanReadableName);
        FieldMetadata foundField = null;
        for (FieldMetadata field : fields) {
            if (!field.getHumanReadableName().equalsIgnoreCase(fieldName)) continue;
            foundField = field;
            break;
        }
        if (foundField == null) {
            throw new RuntimeException("Field with the name \"" + fieldName + "\" does not exist!");
        }
        if (!foundField.isModifiable()) {
            throw new RuntimeException("Field with the name \"" + fieldName + "\" is not modifiable!");
        }
        if (foundField.isArray()) {
            throw new RuntimeException("Field with the name \"" + fieldName + "\" is an array field, use the array modifications!");
        }
        final FieldMetadata foundFieldFinal = foundField;
        jira.updateTicket(ticketKey, new JIRAAccessTool.BuildingLambda<IssueUpdateBuilder>(){

            @Override
            public void build(IssueUpdateBuilder b) {
                b.setFieldValue(foundFieldFinal.getInternalName(), foundFieldFinal.getElementType(), varReplacer.replace(SetFieldModification.this.valueToSet));
            }
        });
    }

    @Extension
    public static class DescribtorImpl
    extends Descriptor<TicketModification> {
        public String getDisplayName() {
            return "Set Field Value";
        }

        public ComboBoxModel doFillFieldHumanReadableNameItems(@RelativePath(value="../..") @QueryParameter String jiraCredentialsID) {
            ComboBoxModel result = new ComboBoxModel();
            for (FieldMetadata field : JIRAMetadataCache.getSingleton().getFieldMetadata(jiraCredentialsID)) {
                Set<String> allowedTypes = IssueUpdateBuilder.SUPPORTED_TYPES;
                if (field.isArray() || !field.isModifiable() || !allowedTypes.contains(field.getElementType())) continue;
                result.add((Object)field.getHumanReadableName());
            }
            return result;
        }
    }
}

