/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.releaseplugin.ticketing;

import hudson.Extension;
import hudson.RelativePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.ComboBoxModel;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.text.StrSubstitutor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import rocks.inspectit.releaseplugin.FieldMetadata;
import rocks.inspectit.releaseplugin.IssueUpdateBuilder;
import rocks.inspectit.releaseplugin.JIRAAccessTool;
import rocks.inspectit.releaseplugin.JIRAMetadataCache;

public class AddTicketField
extends AbstractDescribableImpl<AddTicketField> {
    private String fieldHumanReadableName;
    private String valueToSet;

    @DataBoundConstructor
    public AddTicketField(String fieldHumanReadableName, String valueToSet) {
        this.fieldHumanReadableName = fieldHumanReadableName;
        this.valueToSet = valueToSet;
    }

    public String getFieldHumanReadableName() {
        return this.fieldHumanReadableName;
    }

    public String getValueToSet() {
        return this.valueToSet;
    }

    public void apply(IssueUpdateBuilder fieldModifications, JIRAAccessTool jira, StrSubstitutor varReplacer, PrintStream logger) {
        List<FieldMetadata> fields = JIRAMetadataCache.getSingleton().getFieldMetadata(jira.getJenkinsCredentialsId());
        String fieldName = varReplacer.replace(this.fieldHumanReadableName);
        FieldMetadata foundField = null;
        for (FieldMetadata field : fields) {
            if (!field.getHumanReadableName().equalsIgnoreCase(fieldName)) continue;
            foundField = field;
            break;
        }
        if (foundField == null) {
            throw new RuntimeException("Field with the name \"" + fieldName + "\" does not exist!");
        }
        if (!foundField.isModifiable()) {
            throw new RuntimeException("Field with the name \"" + fieldName + "\" is not modifiable!");
        }
        String val = varReplacer.replace(this.valueToSet);
        if (!foundField.isArray()) {
            fieldModifications.setFieldValue(foundField.getInternalName(), foundField.getElementType(), val);
        } else {
            fieldModifications.setArrayField(foundField.getInternalName(), foundField.getElementType(), val);
        }
    }

    public FieldMetadata getFieldMeta(String jenkinsCredentialsId, StrSubstitutor varReplacer) {
        String name = varReplacer.replace(this.fieldHumanReadableName);
        for (FieldMetadata fm : JIRAMetadataCache.getSingleton().getFieldMetadata(jenkinsCredentialsId)) {
            if (!fm.getHumanReadableName().equalsIgnoreCase(name)) continue;
            return fm;
        }
        return null;
    }

    @Extension
    public static class DescribtorImpl
    extends Descriptor<AddTicketField> {
        public String getDisplayName() {
            return "Specify Field Value";
        }

        public ComboBoxModel doFillFieldHumanReadableNameItems(@RelativePath(value="../..") @QueryParameter String jiraCredentialsID) {
            ComboBoxModel result = new ComboBoxModel();
            for (FieldMetadata field : JIRAMetadataCache.getSingleton().getFieldMetadata(jiraCredentialsID)) {
                Set<String> allowedTypes = IssueUpdateBuilder.SUPPORTED_TYPES;
                if (!field.isModifiable() || !allowedTypes.contains(field.getElementType())) continue;
                result.add((Object)field.getHumanReadableName());
            }
            return result;
        }
    }
}

