/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.recipe.mechanisms;

import hudson.Extension;
import hudson.ProxyConfiguration;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.recipe.Recipe;
import org.jenkinsci.plugins.recipe.mechanisms.ExportMechanism;
import org.jenkinsci.plugins.recipe.mechanisms.ExportMechanismDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class GistMechanism
extends ExportMechanism {
    @DataBoundConstructor
    public GistMechanism() {
    }

    public HttpResponse doExport(StaplerRequest req) throws IOException {
        Recipe r = this.getRecipe();
        StringWriter sw = new StringWriter();
        r.writeTo(sw);
        JSONObject payload = new JSONObject().accumulate("description", (Object)r.getDisplayName()).accumulate("public", true).accumulate("files", (Object)new JSONObject().accumulate(r.getFileName(), (Object)new JSONObject().accumulate("content", (Object)sw.toString())));
        URL url = new URL("https://api.github.com/gists");
        ProxyConfiguration cfr_ignored_0 = Jenkins.getInstance().proxy;
        HttpURLConnection con = (HttpURLConnection)ProxyConfiguration.open((URL)url);
        con.setRequestProperty("Content-type", "application/json;charset=UTF-8");
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        OutputStreamWriter out = new OutputStreamWriter(con.getOutputStream(), "UTF-8");
        out.write(payload.toString(2));
        ((Writer)out).close();
        if (con.getResponseCode() != 201) {
            return HttpResponses.error((int)500, (String)("Failed to create Gist: " + con.getResponseCode() + ":" + con.getResponseMessage()));
        }
        return HttpResponses.redirectTo((String)con.getHeaderField("Location").replace("api.github.com/gists", "gist.github.com"));
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.getRecipe().generateResponse(req, rsp, null);
    }

    @Extension
    public static class DescriptorImpl
    extends ExportMechanismDescriptor {
        public String getDisplayName() {
            return "Create a Gist";
        }
    }
}

