/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.recipe.ingredients;

import com.thoughtworks.xstream.XStream;
import hudson.Extension;
import hudson.model.View;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import jenkins.model.Jenkins;
import jenkins.util.xstream.XStreamDOM;
import org.jenkinsci.plugins.recipe.ImportReportList;
import org.jenkinsci.plugins.recipe.Ingredient;
import org.jenkinsci.plugins.recipe.IngredientDescriptor;
import org.jenkinsci.plugins.recipe.Recipe;
import org.kohsuke.stapler.DataBoundConstructor;

public class ViewIngredient
extends Ingredient {
    private String name;
    private XStreamDOM definition;

    public ViewIngredient(String name, XStreamDOM definition) {
        this.name = name;
        this.definition = definition;
    }

    @DataBoundConstructor
    public ViewIngredient(String name) {
        this.name = name;
        View v = Jenkins.getInstance().getView(name);
        if (v == null) {
            throw new IllegalArgumentException("no such view " + name);
        }
        this.definition = ViewIngredient.parse(v);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public XStreamDOM getDefinition() {
        return this.definition;
    }

    public void cook(Recipe recipe, ImportReportList reportList) throws IOException {
        XStreamDOM actual = recipe.createImportOptions().apply(this.definition);
        actual.getChildren().add(new XStreamDOM("name", Collections.emptyMap(), this.name));
        View v = (View)Jenkins.XSTREAM2.unmarshal(actual.newReader());
        Jenkins.getInstance().addView(v);
    }

    public static ViewIngredient fromView(View v) {
        XStreamDOM dom = ViewIngredient.parse(v);
        return new ViewIngredient(v.getViewName(), dom);
    }

    private static XStreamDOM parse(View v) {
        XStreamDOM dom = XStreamDOM.from((XStream)Jenkins.XSTREAM2, (Object)v);
        Iterator itr = dom.getChildren().iterator();
        while (itr.hasNext()) {
            XStreamDOM c = (XStreamDOM)itr.next();
            if (!c.getTagName().equals("owner") && !c.getTagName().equals("name")) continue;
            itr.remove();
        }
        return dom;
    }

    @Extension
    public static class DescriptorImpl
    extends IngredientDescriptor {
        public String getDisplayName() {
            return "View";
        }
    }
}

