/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.recipe.ingredients;

import hudson.Extension;
import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.Util;
import hudson.model.UpdateCenter;
import hudson.model.UpdateSite;
import hudson.util.IOException2;
import hudson.util.ListBoxModel;
import hudson.util.VersionNumber;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.recipe.ImportReportList;
import org.jenkinsci.plugins.recipe.Ingredient;
import org.jenkinsci.plugins.recipe.IngredientDescriptor;
import org.jenkinsci.plugins.recipe.Recipe;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginIngredient
extends Ingredient {
    public final String names;

    public PluginIngredient(String names) {
        this.names = names;
    }

    @DataBoundConstructor
    public PluginIngredient(List<String> names) {
        this.names = Util.join(names, (String)" ");
    }

    @Override
    public boolean isVisibleDuringImport() {
        return false;
    }

    public List<String> getNameList() {
        return Arrays.asList(this.names.split("[, \t]+"));
    }

    public List<Item> parse() {
        ArrayList<Item> r = new ArrayList<Item>();
        for (String name : this.getNameList()) {
            r.add(new Item(name));
        }
        return r;
    }

    @Override
    protected void cook(Recipe recipe, ImportReportList reportList) throws IOException, InterruptedException {
    }

    @Extension
    public static class DescriptorImpl
    extends IngredientDescriptor {
        public String getDisplayName() {
            return "Plugin";
        }

        public ListBoxModel doFillNamesItems() {
            ListBoxModel r = new ListBoxModel();
            for (PluginWrapper p : Jenkins.getInstance().pluginManager.getPlugins()) {
                r.add(p.getShortName());
            }
            return r;
        }
    }

    public static final class Item {
        public final String name;
        public final VersionNumber version;
        public final PluginWrapper current;
        public final UpdateSite.Plugin installSource;

        public Item(String token) {
            int idx = token.lastIndexOf(64);
            if (idx >= 0) {
                this.name = token.substring(0, idx);
                this.version = new VersionNumber(token.substring(idx + 1));
            } else {
                this.name = token;
                this.version = null;
            }
            PluginManager pm = Jenkins.getInstance().pluginManager;
            UpdateCenter uc = Jenkins.getInstance().getUpdateCenter();
            this.installSource = uc.getPlugin(this.name);
            this.current = pm.getPlugin(this.name);
        }

        public void cook(ImportReportList reportList) throws IOException2, InterruptedException {
            try {
                if (this.current == null) {
                    if (this.installSource != null) {
                        this.installSource.deploy(true).get();
                    }
                } else if (this.version != null && !this.isUpToDate()) {
                    this.installSource.deploy(true).get();
                }
            }
            catch (ExecutionException e) {
                throw new IOException2("Failed to install plugin: " + this.name, (Throwable)e);
            }
        }

        public boolean isUpToDate() {
            if (this.current == null) {
                return false;
            }
            if (this.version == null) {
                return true;
            }
            return this.version.compareTo(this.current.getVersionNumber()) <= 0;
        }
    }
}

