/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.recipe.ingredients;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.XppDriver;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.AutoCompletionCandidates;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.TopLevelItem;
import hudson.util.FormValidation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import jenkins.model.Jenkins;
import jenkins.util.xstream.XStreamDOM;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.jenkinsci.plugins.recipe.ImportReport;
import org.jenkinsci.plugins.recipe.ImportReportList;
import org.jenkinsci.plugins.recipe.Ingredient;
import org.jenkinsci.plugins.recipe.IngredientDescriptor;
import org.jenkinsci.plugins.recipe.Recipe;
import org.jenkinsci.plugins.recipe.RecipeWizard;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class JobIngredient
extends Ingredient {
    private String name;
    private String description;
    private XStreamDOM definition;

    public JobIngredient(String name, String description, XStreamDOM definition) {
        this.name = name;
        this.description = description;
        this.definition = definition;
    }

    @DataBoundConstructor
    public JobIngredient(String name, String description) {
        this.name = name;
        this.description = description;
        AbstractProject i = (AbstractProject)Jenkins.getInstance().getItemByFullName(name, AbstractProject.class);
        if (i == null) {
            throw new IllegalArgumentException("No such job: " + name);
        }
        this.definition = XStreamDOM.from((XStream)i.getConfigFile().getXStream(), (Object)i);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public XStreamDOM getDefinition() {
        return this.definition;
    }

    public void cook(Recipe recipe, ImportReportList reportList) throws IOException {
        XStreamDOM actual = recipe.createImportOptions().apply(this.definition);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XStreamDOM.ConverterImpl c = new XStreamDOM.ConverterImpl();
        c.marshal((Object)actual, new XppDriver().createWriter((OutputStream)baos), null);
        Jenkins g = Jenkins.getInstance();
        TopLevelItem j = (TopLevelItem)g.getItem(this.name);
        ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
        if (j == null) {
            j = g.createProjectFromXML(this.name, (InputStream)is);
        } else if (j instanceof AbstractItem) {
            StreamSource source = new StreamSource(is);
            ((AbstractItem)j).updateByXml((Source)source);
        } else {
            throw new IOException("Cannot update " + j + " in place");
        }
        reportList.add(new ImportReportImpl(j));
    }

    public static JobIngredient fromJob(Job j, String description) {
        XStreamDOM dom = XStreamDOM.from((XStream)j.getConfigFile().getXStream(), (Object)j);
        return new JobIngredient(j.getName(), description, dom);
    }

    @Extension
    public static class DescriptorImpl
    extends IngredientDescriptor {
        public String getDisplayName() {
            return "Job";
        }

        public AutoCompletionCandidates doAutoCompleteChildProjects(@QueryParameter String value) {
            return AutoCompletionCandidates.ofJobNames(AbstractProject.class, (String)value, null, (ItemGroup)Jenkins.getInstance());
        }

        public FormValidation doCheckName(@QueryParameter String name, @AncestorInPath RecipeWizard wizard) {
            AbstractProject i = (AbstractProject)Jenkins.getInstance().getItemByFullName(name, AbstractProject.class);
            if (wizard.isExport()) {
                if (i == null) {
                    return FormValidation.error((String)("No such job: " + name));
                }
            } else if (i != null) {
                return FormValidation.warning((String)("You already have a job named " + name + "; its configuration will be overwritten (but history retained)"));
            }
            return FormValidation.ok();
        }
    }

    public static class ImportReportImpl
    extends ImportReport {
        public final TopLevelItem job;

        public ImportReportImpl(TopLevelItem job) {
            this.job = job;
        }
    }
}

