/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.recipe;

import hudson.util.IOException2;
import hudson.util.VersionNumber;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static void sendRedirect(StaplerResponse rsp, int statusCode, String url) throws IOException {
        if (statusCode == 302) {
            rsp.sendRedirect(url);
            return;
        }
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            StaplerRequest req = Stapler.getCurrentRequest();
            if (!url.startsWith("/")) {
                String base = req.getRequestURI();
                base = base.substring(0, base.lastIndexOf(47) + 1);
                url = !url.equals(".") ? base + url : base;
                assert (url.startsWith("/"));
            }
            StringBuilder buf = new StringBuilder(req.getScheme()).append("://").append(req.getServerName());
            if (req.getScheme().equals("http") && req.getServerPort() != 80 || req.getScheme().equals("https") && req.getServerPort() != 443) {
                buf.append(':').append(req.getServerPort());
            }
            url = buf.append(url).toString();
        }
        rsp.setStatus(statusCode);
        rsp.setHeader("Location", url);
        rsp.getOutputStream().close();
    }

    static Map<String, VersionNumber> parseRequestedPlugins(InputStream configXml) throws IOException {
        final TreeMap<String, VersionNumber> requestedPlugins = new TreeMap<String, VersionNumber>();
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(configXml, new DefaultHandler(){

                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    String plugin = attributes.getValue("plugin");
                    if (plugin == null) {
                        return;
                    }
                    if (!plugin.matches("[^@]+@[^@]+")) {
                        throw new SAXException("Malformed plugin attribute: " + plugin);
                    }
                    int at = plugin.indexOf(64);
                    String shortName = plugin.substring(0, at);
                    VersionNumber existing = (VersionNumber)requestedPlugins.get(shortName);
                    VersionNumber requested = new VersionNumber(plugin.substring(at + 1));
                    if (existing == null || existing.compareTo(requested) < 0) {
                        requestedPlugins.put(shortName, requested);
                    }
                }
            });
        }
        catch (SAXException x) {
            throw new IOException2("Failed to parse XML", (Throwable)x);
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        return requestedPlugins;
    }
}

