/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.recipe;

import hudson.Extension;
import hudson.model.DownloadService;
import hudson.util.VersionNumber;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.recipe.ImportWizard;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
@ExportedBean
public class RecipeCatalog
extends DownloadService.Downloadable {
    public RecipeCatalog() {
        super(RecipeCatalog.class.getName());
    }

    @Exported
    public List<CommuntiyRecipe> getRecipes() throws IOException {
        JSONObject d = this.getData();
        if (d == null) {
            return Collections.emptyList();
        }
        return JSONArray.toList((JSONArray)d.getJSONArray("list"), CommuntiyRecipe.class);
    }

    public CommuntiyRecipe getRecipe(String id) throws IOException {
        for (CommuntiyRecipe r : this.getRecipes()) {
            if (!r.id.equals(id)) continue;
            return r;
        }
        return null;
    }

    @ExportedBean
    public static class CommuntiyRecipe {
        @Exported
        public String author;
        @Exported
        public String displayName;
        @Exported
        public String description;
        @Exported
        public String id;
        @Exported
        public String version;
        @Exported
        public long timestamp;
        @Exported
        public String url;

        public VersionNumber parseVersion() {
            return new VersionNumber(this.version);
        }

        public HttpResponse doImport() throws IOException {
            return ImportWizard.get().doRetrieve(new URL(this.url));
        }
    }
}

