/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.recipe;

import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.IOUtils;
import hudson.util.VariableResolver;
import hudson.util.VersionNumber;
import hudson.util.XStream2;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import jenkins.util.xstream.XStreamDOM;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.recipe.ImportReportList;
import org.jenkinsci.plugins.recipe.Ingredient;
import org.jenkinsci.plugins.recipe.IngredientDescriptor;
import org.jenkinsci.plugins.recipe.Util;
import org.jenkinsci.plugins.recipe.ingredients.Parameter;
import org.jenkinsci.plugins.recipe.ingredients.PluginIngredient;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Recipe
extends AbstractDescribableImpl<Recipe>
implements HttpResponse {
    private String id;
    private String version;
    private String displayName;
    private String description;
    private List<Ingredient> ingredients = new ArrayList<Ingredient>();
    public static XStream2 XSTREAM = new XStream2();
    public static final String EXTENSION = ".jrcp";
    public static final Pattern ID_PATTERN = Pattern.compile("[A-Za-z0-9\\-._]+");

    @DataBoundConstructor
    public Recipe(String id, String version, String displayName, String description, List<? extends Ingredient> ingredients) {
        this.setId(id);
        this.version = version;
        this.displayName = displayName;
        this.description = description;
        this.ingredients.addAll(hudson.Util.fixNull(ingredients));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (!ID_PATTERN.matcher(id).matches()) {
            throw new IllegalArgumentException("Invalid ID: " + id);
        }
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getFileName() {
        return this.id + EXTENSION;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public List<Parameter> getParameters() {
        return this.getIngredients(Parameter.class);
    }

    public <T extends Ingredient> List<T> getIngredients(Class<T> type) {
        return hudson.Util.filter(this.ingredients, type);
    }

    public void writeTo(OutputStream out) throws IOException {
        XSTREAM.toXML((Object)this, out);
    }

    public void writeTo(Writer out) throws IOException {
        XSTREAM.toXML((Object)this, out);
    }

    public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
        rsp.setContentType("application/xml;charset=UTF-8");
        XSTREAM.toXML((Object)this, (OutputStream)rsp.getOutputStream());
    }

    public void apply(StaplerRequest req) throws ServletException {
        JSONObject structure = req.getSubmittedForm();
        for (int i = 0; i < this.getIngredients().size(); ++i) {
            this.getIngredients().get(i).apply(req, structure.getJSONObject("ingredient" + i));
        }
    }

    public void cook(ImportReportList reportList) throws IOException, InterruptedException {
        for (Ingredient i : this.getIngredients()) {
            i.cook(this, reportList);
        }
    }

    public ImportOptions createImportOptions() {
        return new ImportOptions();
    }

    public static Recipe load(URL url) throws IOException {
        byte[] payload = IOUtils.toByteArray((InputStream)url.openStream());
        Recipe recipe = (Recipe)((Object)XSTREAM.fromXML((InputStream)new ByteArrayInputStream(payload)));
        Map<String, VersionNumber> map = Util.parseRequestedPlugins(new ByteArrayInputStream(payload));
        if (!map.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (Map.Entry<String, VersionNumber> e : map.entrySet()) {
                if (buf.length() > 0) {
                    buf.append(',');
                }
                buf.append(e.getKey()).append('@').append(e.getValue());
            }
            PluginIngredient pi = new PluginIngredient(buf.toString());
            recipe.getIngredients().add(pi);
        }
        return recipe;
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED)
    public static void init() {
        XSTREAM.alias("recipe", Recipe.class);
        for (IngredientDescriptor d : IngredientDescriptor.all()) {
            XSTREAM.alias(d.getPersistenceElementName(), d.clazz);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<Recipe> {
        public String getDisplayName() {
            return "";
        }

        public FormValidation doCheckVersion(@QueryParameter String value) {
            try {
                new VersionNumber(value);
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)(value + " is not a valid version number"));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ImportOptions
    implements VariableResolver<String> {
        private final VariableResolver<String> resolver;

        private ImportOptions() {
            HashMap<String, String> variables = new HashMap<String, String>();
            for (Parameter p : Recipe.this.getParameters()) {
                variables.put(p.name, p.getValue());
            }
            this.resolver = new VariableResolver.ByMap(variables);
        }

        public String resolve(String s) {
            return (String)this.resolver.resolve(s);
        }

        public XStreamDOM apply(XStreamDOM dom) {
            return dom.expandMacro(this.resolver);
        }

        public String apply(String s) {
            return hudson.Util.replaceMacro((String)s, this.resolver);
        }
    }
}

