/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.recipe;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ManagementLink;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.jenkinsci.plugins.recipe.ImportConversation;
import org.jenkinsci.plugins.recipe.Recipe;
import org.jenkinsci.plugins.recipe.RecipeCatalog;
import org.jenkinsci.plugins.recipe.RecipeWizard;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class ImportWizard
extends ManagementLink
implements RecipeWizard {
    @Inject
    private RecipeCatalog catalog;

    public RecipeCatalog getCatalog() {
        return this.catalog;
    }

    public String getIconFileName() {
        return "/plugin/recipe/images/48x48/import.png";
    }

    public String getUrlName() {
        return "recipe-import";
    }

    public String getDisplayName() {
        return "Import Recipe";
    }

    public String getDescription() {
        return "Import jobs, views, and so on from a recipe XML file.";
    }

    public boolean isImport() {
        return true;
    }

    public boolean isExport() {
        return false;
    }

    public Descriptor getDescriptorByName(String id) {
        return Jenkins.getInstance().getDescriptorByName(id);
    }

    public HttpResponse doRetrieve(@QueryParameter URL url) throws IOException {
        if (url.getProtocol().equals("file")) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        }
        return this.retrieve(url);
    }

    private HttpResponse retrieve(URL url) throws IOException {
        ImportConversation ic = new ImportConversation(Recipe.load(url));
        return HttpResponses.redirectViaContextPath((String)(this.getUrlName() + "/conversation"));
    }

    public HttpResponse doUpload(StaplerRequest req) throws IOException, ServletException {
        try {
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
            FileItem fileItem = (FileItem)upload.parseRequest((HttpServletRequest)req).get(0);
            File f = File.createTempFile("uploaded", "jrcp");
            fileItem.write(f);
            fileItem.delete();
            return this.retrieve(f.toURI().toURL());
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public ImportConversation getConversation() {
        return ImportConversation.getCurrent();
    }

    public static ImportWizard get() {
        return (ImportWizard)ImportWizard.all().get(ImportWizard.class);
    }
}

