/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.recipe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.recipe.ImportReportList;
import org.jenkinsci.plugins.recipe.Recipe;
import org.jenkinsci.plugins.recipe.ingredients.PluginIngredient;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportConversation {
    public final Recipe recipe;
    public Exception error;
    public ImportReportList reportList = new ImportReportList();
    private boolean skipPlugin;
    private static final String SESSION_KEY = ImportConversation.class.getName();

    public ImportConversation(Recipe recipe) {
        this.recipe = recipe;
        Stapler.getCurrentRequest().getSession().setAttribute(SESSION_KEY, (Object)this);
    }

    public static ImportConversation getCurrent() {
        return (ImportConversation)Stapler.getCurrentRequest().getSession().getAttribute(SESSION_KEY);
    }

    public List<PluginIngredient.Item> getPluginsThatRequireAttention() {
        ArrayList<PluginIngredient.Item> r = new ArrayList<PluginIngredient.Item>();
        if (this.skipPlugin) {
            return r;
        }
        for (PluginIngredient p : this.recipe.getIngredients(PluginIngredient.class)) {
            for (PluginIngredient.Item i : p.parse()) {
                if (i.isUpToDate()) continue;
                r.add(i);
            }
        }
        return r;
    }

    public HttpResponse doApplyPlugins(StaplerRequest req) {
        if (req.hasParameter("skip")) {
            this.skipPlugin = true;
            return HttpResponses.redirectToDot();
        }
        HashMap<String, PluginIngredient.Item> r = new HashMap<String, PluginIngredient.Item>();
        for (PluginIngredient.Item i : this.getPluginsThatRequireAttention()) {
            r.put(i.name, i);
        }
        boolean change = false;
        for (String name : req.getParameterMap().keySet()) {
            PluginIngredient.Item i;
            if (!name.startsWith("plugin.") || (i = (PluginIngredient.Item)r.remove(name.substring(7))) == null) continue;
            i.installSource.deploy(true);
            change = true;
        }
        if (change) {
            return HttpResponses.redirectViaContextPath((String)"/updateCenter/");
        }
        this.skipPlugin = true;
        return HttpResponses.redirectToDot();
    }

    public HttpResponse doCook(StaplerRequest req) throws ServletException {
        this.recipe.apply(req);
        try {
            this.reportList = new ImportReportList();
            this.recipe.cook(this.reportList);
            return HttpResponses.redirectTo((String)"report");
        }
        catch (IOException e) {
            this.error = e;
            return HttpResponses.redirectToDot();
        }
        catch (InterruptedException e) {
            this.error = e;
            return HttpResponses.redirectToDot();
        }
    }
}

