/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.recipe;

import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ManagementLink;
import java.io.IOException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.recipe.Recipe;
import org.jenkinsci.plugins.recipe.RecipeWizard;
import org.jenkinsci.plugins.recipe.Util;
import org.jenkinsci.plugins.recipe.mechanisms.DownloadMechanism;
import org.jenkinsci.plugins.recipe.mechanisms.ExportMechanism;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class ExportWizard
extends ManagementLink
implements RecipeWizard,
Describable<ExportWizard> {
    private static final String RECIPE = ExportWizard.class.getName() + ".recipe";

    public String getIconFileName() {
        return "/plugin/recipe/images/48x48/export.png";
    }

    public String getUrlName() {
        return "recipe-export";
    }

    public String getDisplayName() {
        return "Export Recipe";
    }

    public String getDescription() {
        return "Export jobs, views, and so on as an XML file so that others can import them into their Jenkins.";
    }

    @Override
    public boolean isImport() {
        return false;
    }

    @Override
    public boolean isExport() {
        return true;
    }

    public Descriptor getDescriptorByName(String id) {
        return Jenkins.getInstance().getDescriptorByName(id);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    public Recipe getRecipe() {
        ExportMechanism t = this.getMechanism();
        if (t != null) {
            return t.getRecipe();
        }
        return null;
    }

    public ExportMechanism getMechanism() {
        ExportMechanism e = (ExportMechanism)((Object)Stapler.getCurrentRequest().getSession().getAttribute(RECIPE));
        if (e == null) {
            e = new DownloadMechanism();
        }
        return e;
    }

    public void doExport(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Recipe recipe = (Recipe)((Object)req.bindJSON(Recipe.class, req.getSubmittedForm().getJSONObject("recipe")));
        ExportMechanism mechanism = (ExportMechanism)((Object)req.bindJSON(ExportMechanism.class, req.getSubmittedForm().getJSONObject("mechanism")));
        mechanism.setRecipe(recipe);
        req.getSession().setAttribute(RECIPE, (Object)mechanism);
        Util.sendRedirect(rsp, 303, "mechanism/export");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<ExportWizard> {
        public String getDisplayName() {
            return "";
        }
    }
}

