/*
 * Decompiled with CFR 0.152.
 */
package com.midvision.rapiddeploy.plugin.jenkins.postbuildstep;

import com.midvision.rapiddeploy.plugin.jenkins.RapidDeployConnectorProxy;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class RapidDeployJobPlanRunner
extends Notifier {
    private final String serverUrl;
    private final String authenticationToken;
    private final String jobPlan;
    private final Boolean asynchronousJob;
    private final Boolean showFullLogs;
    private static final Log logger = LogFactory.getLog(RapidDeployJobPlanRunner.class);

    @DataBoundConstructor
    public RapidDeployJobPlanRunner(String serverUrl, String authenticationToken, String jobPlan, Boolean asynchronousJob, Boolean showFullLogs) {
        this.serverUrl = serverUrl;
        this.authenticationToken = authenticationToken;
        this.jobPlan = jobPlan;
        this.asynchronousJob = asynchronousJob;
        this.showFullLogs = showFullLogs;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        return RapidDeployConnectorProxy.performJobPlanRun(listener, this.serverUrl, this.authenticationToken, this.jobPlan, this.asynchronousJob, this.showFullLogs);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getJobPlan() {
        return this.jobPlan;
    }

    public String getAuthenticationToken() {
        return this.authenticationToken;
    }

    public Boolean getAsynchronousJob() {
        return this.asynchronousJob;
    }

    public Boolean getShowFullLogs() {
        return this.showFullLogs;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private final RapidDeployConnectorProxy rdProxy = new RapidDeployConnectorProxy();

        public DescriptorImpl() {
            super(RapidDeployJobPlanRunner.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "RapidDeploy job plan runner";
        }

        @RequirePOST
        public FormValidation doCheckServerUrl(@QueryParameter String value, @AncestorInPath Item item) throws IOException, ServletException {
            logger.debug((Object)"doCheckServerUrl");
            if (item == null) {
                return FormValidation.ok();
            }
            if (!item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.warning((String)"Insufficient permissions to perform the check.");
            }
            this.rdProxy.setNewConnection(true);
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a value for this field!");
            }
            if (!value.startsWith("http://") && !value.startsWith("https://")) {
                return FormValidation.warning((String)"Please specify a protocol for the URL, e.g. \"http://\".");
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckAuthenticationToken(@QueryParameter String value, @AncestorInPath Item item) throws IOException, ServletException {
            logger.debug((Object)"doCheckAuthenticationToken");
            if (item == null) {
                return FormValidation.ok();
            }
            if (!item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.warning((String)"Insufficient permissions to perform the check.");
            }
            this.rdProxy.setNewConnection(true);
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a value for this field!");
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doLoadJobPlans(@QueryParameter(value="serverUrl") String serverUrl, @QueryParameter(value="authenticationToken") String authenticationToken, @AncestorInPath Item item) throws IOException, ServletException {
            logger.debug((Object)"doLoadJobPlans");
            if (item == null) {
                return FormValidation.ok();
            }
            if (!item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.warning((String)"Insufficient permissions to perform the check.");
            }
            this.rdProxy.setNewConnection(true);
            if (this.rdProxy.getJobPlans(serverUrl, authenticationToken).isEmpty()) {
                return FormValidation.error((String)"Unable to establish connection.");
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public ListBoxModel doFillJobPlanItems(@QueryParameter(value="serverUrl") String serverUrl, @QueryParameter(value="authenticationToken") String authenticationToken, @AncestorInPath Item item) {
            logger.debug((Object)"doFillJobPlans");
            ListBoxModel listBoxItems = new ListBoxModel();
            if (item == null) {
                return listBoxItems;
            }
            if (!item.hasPermission(Item.CONFIGURE)) {
                return listBoxItems.add("No items retrieved. Insufficient permissions to perform the check.");
            }
            for (String jobPlan : this.rdProxy.getJobPlans(serverUrl, authenticationToken)) {
                listBoxItems.add(jobPlan);
            }
            return listBoxItems;
        }
    }
}

