/*
 * Decompiled with CFR 0.152.
 */
package com.midvision.rapiddeploy.plugin.jenkins.postbuildstep;

import com.midvision.rapiddeploy.plugin.jenkins.RapidDeployConnectorProxy;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class RapidDeployPackageBuilder
extends Notifier {
    private final String serverUrl;
    private final String authenticationToken;
    private final String project;
    private final boolean enableCustomPackageName;
    private final String packageName;
    private final String archiveExtension;
    private static final Log logger = LogFactory.getLog(RapidDeployPackageBuilder.class);

    @DataBoundConstructor
    public RapidDeployPackageBuilder(String serverUrl, String authenticationToken, String project, boolean enableCustomPackageName, String packageName, String archiveExtension) {
        this.serverUrl = serverUrl;
        this.authenticationToken = authenticationToken;
        this.project = project;
        this.enableCustomPackageName = enableCustomPackageName;
        this.packageName = packageName;
        this.archiveExtension = archiveExtension;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        return RapidDeployConnectorProxy.performPackageBuild(build, listener, this.serverUrl, this.authenticationToken, this.project, this.getPackageName(), this.archiveExtension);
    }

    public String getProject() {
        return this.project;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getAuthenticationToken() {
        return this.authenticationToken;
    }

    public boolean getEnableCustomPackageName() {
        return this.enableCustomPackageName;
    }

    public String getPackageName() {
        if (this.enableCustomPackageName) {
            return this.packageName;
        }
        return "";
    }

    public String getArchiveExtension() {
        return this.archiveExtension;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private static final String NOT_EMPTY_MESSAGE = "Please set a value for this field!";
        private static final String NO_PROTOCOL_MESSAGE = "Please specify a protocol for the URL, e.g. \"http://\".";
        private static final String CONNECTION_BAD_MESSAGE = "Unable to establish connection.";
        private static final String WRONG_PROJECT_MESSAGE = "Wrong project selected, please reload the projects list.";
        private final RapidDeployConnectorProxy rdProxy = new RapidDeployConnectorProxy();

        public DescriptorImpl() {
            super(RapidDeployPackageBuilder.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "RapidDeploy deployment package build";
        }

        public FormValidation doCheckServerUrl(@QueryParameter String value) throws IOException, ServletException {
            logger.debug((Object)"doCheckServerUrl");
            this.rdProxy.setNewConnection(true);
            if (value.length() == 0) {
                return FormValidation.error((String)NOT_EMPTY_MESSAGE);
            }
            if (!value.startsWith("http://") && !value.startsWith("https://")) {
                return FormValidation.warning((String)NO_PROTOCOL_MESSAGE);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAuthenticationToken(@QueryParameter String value) throws IOException, ServletException {
            logger.debug((Object)"doCheckAuthenticationToken");
            this.rdProxy.setNewConnection(true);
            if (value.length() == 0) {
                return FormValidation.error((String)NOT_EMPTY_MESSAGE);
            }
            return FormValidation.ok();
        }

        public FormValidation doLoadProjects(@QueryParameter(value="serverUrl") String serverUrl, @QueryParameter(value="authenticationToken") String authenticationToken) throws IOException, ServletException {
            logger.debug((Object)"doLoadProjects");
            this.rdProxy.setNewConnection(true);
            if (this.rdProxy.getProjects(serverUrl, authenticationToken).isEmpty()) {
                return FormValidation.error((String)CONNECTION_BAD_MESSAGE);
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillProjectItems(@QueryParameter(value="serverUrl") String serverUrl, @QueryParameter(value="authenticationToken") String authenticationToken) {
            logger.debug((Object)"doFillProjectItems");
            ListBoxModel items = new ListBoxModel();
            for (String projectName : this.rdProxy.getProjects(serverUrl, authenticationToken)) {
                items.add(projectName);
            }
            return items;
        }

        public FormValidation doGetPackages(@QueryParameter(value="serverUrl") String serverUrl, @QueryParameter(value="authenticationToken") String authenticationToken, @QueryParameter(value="project") String project) throws IOException, ServletException {
            logger.debug((Object)"doGetPackages");
            if (this.rdProxy.getProjects(serverUrl, authenticationToken).contains(project)) {
                String packagesTable = this.rdProxy.createPackagesTable(serverUrl, authenticationToken, project);
                if (packagesTable != null) {
                    return FormValidation.okWithMarkup((String)packagesTable);
                }
            } else {
                if (this.rdProxy.getProjects(serverUrl, authenticationToken).isEmpty()) {
                    return FormValidation.error((String)CONNECTION_BAD_MESSAGE);
                }
                return FormValidation.warning((String)WRONG_PROJECT_MESSAGE);
            }
            return FormValidation.warning((String)("No deployment package could be retrieved for '" + project + "'."));
        }

        public ListBoxModel doFillArchiveExtensionItems() {
            logger.debug((Object)"doFillArchiveExtensionItems");
            ListBoxModel items = new ListBoxModel();
            items.add("jar");
            items.add("war");
            items.add("ear");
            items.add("tar");
            items.add("rar");
            items.add("zip");
            return items;
        }
    }
}

