/*
 * Decompiled with CFR 0.152.
 */
package com.midvision.rapiddeploy.plugin.jenkins.postbuildstep;

import com.midvision.rapiddeploy.plugin.jenkins.RapidDeployConnectorProxy;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class RapidDeployJobRunner
extends Notifier {
    private final String serverUrl;
    private final String authenticationToken;
    private final String project;
    private final String target;
    private final String packageName;
    private final Boolean asynchronousJob;
    private static final Log logger = LogFactory.getLog(RapidDeployJobRunner.class);

    @DataBoundConstructor
    public RapidDeployJobRunner(String serverUrl, String authenticationToken, String project, String target, String packageName, Boolean asynchronousJob) {
        this.serverUrl = serverUrl;
        this.authenticationToken = authenticationToken;
        this.target = target;
        this.packageName = packageName;
        this.project = project;
        this.asynchronousJob = asynchronousJob;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        return RapidDeployConnectorProxy.performJobDeployment(build, listener, this.serverUrl, this.authenticationToken, this.project, this.target, this.packageName, this.asynchronousJob);
    }

    public String getProject() {
        return this.project;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getAuthenticationToken() {
        return this.authenticationToken;
    }

    public String getTarget() {
        return this.target;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Boolean getAsynchronousJob() {
        return this.asynchronousJob;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private static final String NOT_EMPTY_MESSAGE = "Please set a value for this field!";
        private static final String NO_PROTOCOL_MESSAGE = "Please specify a protocol for the URL, e.g. \"http://\".";
        private static final String CONNECTION_BAD_MESSAGE = "Unable to establish connection.";
        private final RapidDeployConnectorProxy rdProxy = new RapidDeployConnectorProxy();

        public DescriptorImpl() {
            super(RapidDeployJobRunner.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "RapidDeploy project deploy";
        }

        public FormValidation doCheckServerUrl(@QueryParameter String value) throws IOException, ServletException {
            logger.debug((Object)"doCheckServerUrl");
            this.rdProxy.setNewConnection(true);
            if (value.length() == 0) {
                return FormValidation.error((String)NOT_EMPTY_MESSAGE);
            }
            if (!value.startsWith("http://") && !value.startsWith("https://")) {
                return FormValidation.warning((String)NO_PROTOCOL_MESSAGE);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAuthenticationToken(@QueryParameter String value) throws IOException, ServletException {
            logger.debug((Object)"doCheckAuthenticationToken");
            this.rdProxy.setNewConnection(true);
            if (value.length() == 0) {
                return FormValidation.error((String)NOT_EMPTY_MESSAGE);
            }
            return FormValidation.ok();
        }

        public FormValidation doLoadProjects(@QueryParameter(value="serverUrl") String serverUrl, @QueryParameter(value="authenticationToken") String authenticationToken) throws IOException, ServletException {
            logger.debug((Object)"doLoadProjects");
            this.rdProxy.setNewConnection(true);
            if (this.rdProxy.getProjects(serverUrl, authenticationToken).isEmpty()) {
                return FormValidation.error((String)CONNECTION_BAD_MESSAGE);
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillProjectItems(@QueryParameter(value="serverUrl") String serverUrl, @QueryParameter(value="authenticationToken") String authenticationToken) {
            logger.debug((Object)"doFillProjectItems");
            ListBoxModel items = new ListBoxModel();
            for (String projectName : this.rdProxy.getProjects(serverUrl, authenticationToken)) {
                items.add(projectName);
            }
            return items;
        }

        public ListBoxModel doFillTargetItems(@QueryParameter(value="serverUrl") String serverUrl, @QueryParameter(value="authenticationToken") String authenticationToken, @QueryParameter(value="project") String project) {
            logger.debug((Object)"doFillTargetItems");
            ListBoxModel items = new ListBoxModel();
            if (!this.rdProxy.getProjects(serverUrl, authenticationToken).isEmpty()) {
                try {
                    List<String> targets = this.rdProxy.getTargets(serverUrl, authenticationToken, project);
                    for (String targetName : targets) {
                        if (targetName.contains("Project [") || targetName.contains("domainxml")) continue;
                        items.add(targetName);
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)e.getMessage());
                }
            }
            return items;
        }

        public ComboBoxModel doFillPackageNameItems(@QueryParameter(value="serverUrl") String serverUrl, @QueryParameter(value="authenticationToken") String authenticationToken, @QueryParameter(value="project") String project, @QueryParameter(value="target") String target) {
            logger.debug((Object)"doFillPackageNameItems");
            ComboBoxModel items = new ComboBoxModel();
            if (!this.rdProxy.getProjects(serverUrl, authenticationToken).isEmpty()) {
                try {
                    items.add((Object)"LATEST");
                    List<String> packageNames = this.rdProxy.getDeploymentPackages(serverUrl, authenticationToken, project, target);
                    for (String packageName : packageNames) {
                        if ("null".equals(packageName) || packageName.startsWith("Deployment")) continue;
                        items.add((Object)packageName);
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)e.getMessage());
                }
            }
            return items;
        }
    }
}

