/*
 * Decompiled with CFR 0.152.
 */
package com.midvision.rapiddeploy.plugin.jenkins.postbuildstep;

import com.midvision.rapiddeploy.plugin.jenkins.RapidDeployConnectorProxy;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class RapidDeployJobPlanRunner
extends Notifier {
    private final String serverUrl;
    private final String authenticationToken;
    private final String jobPlan;
    private final Boolean asynchronousJob;
    private final Boolean showFullLogs;
    private static final Log logger = LogFactory.getLog(RapidDeployJobPlanRunner.class);

    @DataBoundConstructor
    public RapidDeployJobPlanRunner(String serverUrl, String authenticationToken, String jobPlan, Boolean asynchronousJob, Boolean showFullLogs) {
        this.serverUrl = serverUrl;
        this.authenticationToken = authenticationToken;
        this.jobPlan = jobPlan;
        this.asynchronousJob = asynchronousJob;
        this.showFullLogs = showFullLogs;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        return RapidDeployConnectorProxy.performJobPlanRun(listener, this.serverUrl, this.authenticationToken, this.jobPlan, this.asynchronousJob, this.showFullLogs);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getJobPlan() {
        return this.jobPlan;
    }

    public String getAuthenticationToken() {
        return this.authenticationToken;
    }

    public Boolean getAsynchronousJob() {
        return this.asynchronousJob;
    }

    public Boolean getShowFullLogs() {
        return this.showFullLogs;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private static final String NOT_EMPTY_MESSAGE = "Please set a value for this field!";
        private static final String NO_PROTOCOL_MESSAGE = "Please specify a protocol for the URL, e.g. \"http://\".";
        private static final String CONNECTION_BAD_MESSAGE = "Unable to establish connection.";
        private final RapidDeployConnectorProxy rdProxy = new RapidDeployConnectorProxy();

        public DescriptorImpl() {
            super(RapidDeployJobPlanRunner.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "RapidDeploy job plan runner";
        }

        public FormValidation doCheckServerUrl(@QueryParameter String value) throws IOException, ServletException {
            logger.debug((Object)"doCheckServerUrl");
            this.rdProxy.setNewConnection(true);
            if (value.length() == 0) {
                return FormValidation.error((String)NOT_EMPTY_MESSAGE);
            }
            if (!value.startsWith("http://") && !value.startsWith("https://")) {
                return FormValidation.warning((String)NO_PROTOCOL_MESSAGE);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAuthenticationToken(@QueryParameter String value) throws IOException, ServletException {
            logger.debug((Object)"doCheckAuthenticationToken");
            this.rdProxy.setNewConnection(true);
            if (value.length() == 0) {
                return FormValidation.error((String)NOT_EMPTY_MESSAGE);
            }
            return FormValidation.ok();
        }

        public FormValidation doLoadJobPlans(@QueryParameter(value="serverUrl") String serverUrl, @QueryParameter(value="authenticationToken") String authenticationToken) throws IOException, ServletException {
            logger.debug((Object)"doLoadJobPlans");
            this.rdProxy.setNewConnection(true);
            if (this.rdProxy.getJobPlans(serverUrl, authenticationToken).isEmpty()) {
                return FormValidation.error((String)CONNECTION_BAD_MESSAGE);
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillJobPlanItems(@QueryParameter(value="serverUrl") String serverUrl, @QueryParameter(value="authenticationToken") String authenticationToken) {
            logger.debug((Object)"doFillJobPlans");
            ListBoxModel items = new ListBoxModel();
            for (String jobPlan : this.rdProxy.getJobPlans(serverUrl, authenticationToken)) {
                items.add(jobPlan);
            }
            return items;
        }
    }
}

