/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.model.EntryComparator;
import hudson.model.IViewEntry;
import hudson.model.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class ProjectViewEntry
implements IViewEntry {
    private TreeSet<IViewEntry> jobs = new TreeSet<IViewEntry>(new EntryComparator());
    private String name;
    private TreeSet<IViewEntry> failing;
    private TreeSet<IViewEntry> completelyPassing;
    private TreeSet<IViewEntry> unstable;
    private int jobsHashCode = -1;

    public ProjectViewEntry(String name) {
        this.name = name;
    }

    public ProjectViewEntry() {
    }

    public TreeSet<IViewEntry> getClaimedBuilds() {
        TreeSet<IViewEntry> failing = new TreeSet<IViewEntry>(new EntryComparator());
        for (IViewEntry job : this.jobs) {
            if (!job.getBroken().booleanValue() && job.getFailCount() <= 0 || !job.isCompletelyClaimed()) continue;
            failing.add(job);
        }
        return failing;
    }

    public TreeSet<IViewEntry> getPassingJobs() {
        this.computePassingAndFailingJobs();
        if (!this.failing.isEmpty()) {
            TreeSet<IViewEntry> aggregate = new TreeSet<IViewEntry>(new EntryComparator());
            aggregate.addAll(this.unstable);
            aggregate.addAll(this.completelyPassing);
            return aggregate;
        }
        return this.completelyPassing;
    }

    public TreeSet<IViewEntry> getFailingJobs() {
        this.computePassingAndFailingJobs();
        if (!this.failing.isEmpty()) {
            return this.failing;
        }
        return this.unstable;
    }

    private void computePassingAndFailingJobs() {
        if (this.jobsHashCode == this.jobs.hashCode()) {
            return;
        }
        this.completelyPassing = new TreeSet<IViewEntry>(new EntryComparator());
        this.failing = new TreeSet<IViewEntry>(new EntryComparator());
        this.unstable = new TreeSet<IViewEntry>(new EntryComparator());
        for (IViewEntry job : this.jobs) {
            if (job.getBroken().booleanValue() || job.getFailCount() > 0) {
                this.failing.add(job);
                continue;
            }
            if (!job.getStable()) {
                this.unstable.add(job);
                continue;
            }
            this.completelyPassing.add(job);
        }
    }

    public TreeSet<IViewEntry> getUnclaimedJobs() {
        TreeSet<IViewEntry> unclaimed = new TreeSet<IViewEntry>(new EntryComparator());
        for (IViewEntry job : this.jobs) {
            if (job.getStable() && job.getFailCount() <= 0 || job.isNotBuilt() || job.isCompletelyClaimed()) continue;
            unclaimed.add(job);
        }
        return unclaimed;
    }

    public TreeSet<IViewEntry> getUnbuiltJobs() {
        TreeSet<IViewEntry> unbuilt = new TreeSet<IViewEntry>(new EntryComparator());
        for (IViewEntry job : this.jobs) {
            if (!job.isNotBuilt()) continue;
            unbuilt.add(job);
        }
        return unbuilt;
    }

    public TreeSet<IViewEntry> getJobs() {
        return this.jobs;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addBuild(IViewEntry entry) {
        Validate.notNull((Object)entry);
        this.jobs.add(entry);
    }

    public String getStatus() {
        if (this.getStable()) {
            return "successful";
        }
        if (this.getUnclaimedJobs().isEmpty()) {
            return "claimed";
        }
        if (this.getBroken().booleanValue()) {
            return "failing";
        }
        return "unstable";
    }

    @Override
    public String getBackgroundColor() {
        if (this.getBroken().booleanValue() || this.getFailCount() > 0) {
            if (this.getUnclaimedJobs().isEmpty()) {
                return "orange";
            }
            return "red";
        }
        return "green";
    }

    @Override
    public Boolean getBroken() {
        boolean broken = false;
        for (IViewEntry job : this.jobs) {
            broken |= job.getBroken().booleanValue();
        }
        return broken;
    }

    @Override
    public boolean isClaimed() {
        boolean claimed = false;
        for (IViewEntry job : this.jobs) {
            claimed |= job.isClaimed();
        }
        return claimed;
    }

    @Override
    public Boolean getBuilding() {
        boolean building = false;
        for (IViewEntry job : this.jobs) {
            building |= job.getBuilding().booleanValue();
        }
        return building;
    }

    @Override
    public String getClaim() {
        StringBuilder claim = new StringBuilder();
        for (IViewEntry job : this.jobs) {
            if (!job.isClaimed()) continue;
            claim.append(job.getName()).append(": ").append(job.getClaim()).append(";");
        }
        return claim.toString();
    }

    @Override
    public String getColor() {
        return "white";
    }

    @Override
    public Collection<String> getCulprits() {
        HashSet<String> culprits = new HashSet<String>();
        for (IViewEntry job : this.getFailingJobs()) {
            culprits.addAll(job.getCulprits());
        }
        return culprits;
    }

    @Override
    public String getCulprit() {
        Collection<String> culprits = this.getCulprits();
        String culprit = null;
        if (!culprits.isEmpty()) {
            culprit = StringUtils.join(culprits, (String)", ");
        }
        return culprit;
    }

    @Override
    public String getDiff() {
        return null;
    }

    @Override
    public String getDiffColor() {
        return null;
    }

    @Override
    public int getFailCount() {
        int count = 0;
        for (IViewEntry job : this.jobs) {
            count += job.getFailCount();
        }
        return count;
    }

    @Override
    public String getLastCompletedBuild() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getLastStableBuild() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean getQueued() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getStable() {
        boolean stable = true;
        for (IViewEntry job : this.jobs) {
            stable &= job.getStable();
        }
        return stable;
    }

    @Override
    public int getSuccessCount() {
        int count = 0;
        for (IViewEntry job : this.jobs) {
            count += job.getSuccessCount();
        }
        return count;
    }

    @Override
    public String getSuccessPercentage() {
        return Integer.toString(100 * this.getSuccessCount() / this.getTestCount());
    }

    @Override
    public int getTestCount() {
        int count = 0;
        for (IViewEntry job : this.jobs) {
            count += job.getTestCount();
        }
        return count;
    }

    @Override
    public String getUrl() {
        return null;
    }

    @Override
    public Result getLastFinishedResult() {
        return null;
    }

    @Override
    public boolean hasChildren() {
        return !this.jobs.isEmpty();
    }

    public String getTitle() {
        ArrayList<String> jobNames = new ArrayList<String>(this.jobs.size());
        for (IViewEntry job : this.jobs) {
            jobNames.add(job.getName());
        }
        return this.getName() + ": " + StringUtils.join(jobNames, (String)", ");
    }

    @Override
    public boolean isCompletelyClaimed() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getUnclaimedMatrixBuilds() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNotBuilt() {
        throw new UnsupportedOperationException();
    }
}

