/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.quayio.trigger;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.UnprotectedRootAction;
import hudson.security.ACL;
import hudson.security.csrf.CrumbExclusion;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.quayio.trigger.PushEventNotification;
import org.jenkinsci.plugins.quayio.trigger.PushEventNotificationCause;
import org.jenkinsci.plugins.quayio.trigger.QuayIoTrigger;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.interceptor.RespondSuccess;

@Extension
public class QuayIoWebHook
extends CrumbExclusion
implements UnprotectedRootAction {
    public static final String URL_PATH = "quayio-webhook";
    private static final int MIN_QUIET = 3;
    private static final Logger logger = Logger.getLogger(QuayIoWebHook.class.getName());

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "Quay.io web hook";
    }

    public String getUrlName() {
        return URL_PATH;
    }

    @RequirePOST
    @RespondSuccess
    public void doPush(StaplerRequest request, StaplerResponse response) throws IOException {
        PushEventNotification notification;
        String body = IOUtils.toString((InputStream)request.getInputStream(), (String)request.getCharacterEncoding());
        try {
            JSONObject payload = JSONObject.fromObject((Object)body);
            notification = new PushEventNotification(payload);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not parse the web hook payload!", e);
            logger.log(Level.FINER, "Payload content: " + body);
            return;
        }
        if (notification != null) {
            this.trigger(response, notification);
        }
    }

    private void trigger(StaplerResponse response, final PushEventNotification notification) throws IOException {
        final Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            return;
        }
        ACL.impersonate((Authentication)ACL.SYSTEM, (Runnable)new Runnable(){

            @Override
            public void run() {
                for (ParameterizedJobMixIn.ParameterizedJob p : jenkins.getAllItems(ParameterizedJobMixIn.ParameterizedJob.class)) {
                    QuayIoTrigger trigger = QuayIoTrigger.getTrigger(p);
                    if (trigger == null) {
                        logger.log(Level.FINER, "job {0} doesn't have QuayIoTrigger set", p.getName());
                        continue;
                    }
                    logger.log(Level.FINER, "Inspecting candidate job {0}", p.getName());
                    if (!trigger.getRepositories().contains(notification.getRepository())) continue;
                    QuayIoWebHook.this.schedule(new JobMixInWrapper((Job)p), notification);
                }
            }
        });
    }

    private void schedule(JobMixInWrapper<?, ?> job, PushEventNotification notification) {
        if (!job.asJob().isBuildable()) {
            return;
        }
        List<ParameterValue> parameters = job.getParameterValues(notification);
        LinkedList<Object> queueActions = new LinkedList<Object>();
        queueActions.add(new ParametersAction(parameters));
        queueActions.add(new CauseAction((Cause)new PushEventNotificationCause(notification)));
        int quiet = Math.max(3, ((ParameterizedJobMixIn.ParameterizedJob)job.asJob()).getQuietPeriod());
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            logger.log(Level.WARNING, "Tried to schedule a build while Jenkins was gone.");
            return;
        }
        job.scheduleBuild2(quiet, queueActions.toArray(new Action[2]));
        logger.info("Scheduled job " + job.asJob().getName() + " as Docker image " + notification.getRepository() + " has been pushed with tags " + StringUtils.join(notification.getTags(), (String)", "));
    }

    public boolean process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null && pathInfo.startsWith("/quayio-webhook")) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        return false;
    }

    static class JobMixInWrapper<JobT extends Job<JobT, RunT> & Queue.Task, RunT extends Run<JobT, RunT>>
    extends ParameterizedJobMixIn<JobT, RunT> {
        public static final String PREFIX = "QUAY_IO_TRIGGER_";
        public static final String KEY_REPOSITORY = "QUAY_IO_TRIGGER_REPOSITORY";
        public static final String KEY_TAG = "QUAY_IO_TRIGGER_TAG";
        private final JobT job;

        public JobMixInWrapper(JobT job) {
            this.job = job;
        }

        protected JobT asJob() {
            return this.job;
        }

        public List<ParameterValue> getParameterValues(PushEventNotification notification) {
            LinkedList<ParameterValue> parameters = new LinkedList<ParameterValue>();
            if (this.isParameterized()) {
                List<ParameterValue> defaults = this.getDefaultParametersValues();
                for (ParameterValue value : defaults) {
                    if (value.getName().equalsIgnoreCase(KEY_REPOSITORY) || value.getName().equalsIgnoreCase(KEY_TAG)) continue;
                    parameters.add(value);
                }
            }
            parameters.add((ParameterValue)new StringParameterValue(KEY_REPOSITORY, notification.getRepository()));
            if (!notification.getTags().isEmpty()) {
                parameters.add((ParameterValue)new StringParameterValue(KEY_TAG, notification.getTags().get(0)));
            }
            return parameters;
        }

        public List<ParameterValue> getDefaultParametersValues() {
            ParametersDefinitionProperty paramDefProp = (ParametersDefinitionProperty)this.asJob().getProperty(ParametersDefinitionProperty.class);
            ArrayList<ParameterValue> defValues = new ArrayList<ParameterValue>();
            if (paramDefProp == null) {
                return defValues;
            }
            for (ParameterDefinition paramDefinition : paramDefProp.getParameterDefinitions()) {
                ParameterValue defaultValue = paramDefinition.getDefaultParameterValue();
                if (defaultValue == null) continue;
                defValues.add(defaultValue);
            }
            return defValues;
        }
    }
}

