/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.quayio.trigger;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class QuayIoTrigger
extends Trigger<Job<?, ?>> {
    private Set<String> repositories;

    @DataBoundConstructor
    public QuayIoTrigger() {
        this.repositories = Collections.emptySet();
    }

    public QuayIoTrigger(Set<String> repositories) {
        this.repositories = repositories;
    }

    @DataBoundSetter
    public void setRepositories(Set<String> repositories) {
        this.repositories = repositories;
    }

    public Set<String> getRepositories() {
        return this.repositories;
    }

    public String getRepositoriesAsMultiline() {
        return StringUtils.join(this.getRepositories(), (String)"\n");
    }

    public static QuayIoTrigger getTrigger(ParameterizedJobMixIn.ParameterizedJob job) {
        DescriptorImpl descriptor;
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null && (descriptor = (DescriptorImpl)jenkins.getDescriptorByType(DescriptorImpl.class)) != null) {
            Map triggers = job.getTriggers();
            return (QuayIoTrigger)((Object)triggers.get((Object)descriptor));
        }
        return null;
    }

    @Extension
    public static class DescriptorImpl
    extends TriggerDescriptor {
        public boolean isApplicable(Item item) {
            return true;
        }

        public String getDisplayName() {
            return "Monitor Quay.io for image changes";
        }

        public Trigger<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JSONArray array = new JSONArray();
            if (formData.has("repositories") && !StringUtils.isBlank((String)formData.optString("repositories"))) {
                array.addAll(Arrays.asList(StringUtils.split((String)formData.getString("repositories"))));
            }
            formData.put("repositories", (Object)array);
            return (Trigger)super.newInstance(req, formData);
        }
    }
}

