/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.plot.AbstractPlotPublisher;
import hudson.plugins.plot.Plot;
import hudson.plugins.plot.PlotAction;
import hudson.plugins.plot.PlotDescriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class PlotPublisher
extends AbstractPlotPublisher {
    private List<Plot> plots = new ArrayList<Plot>();
    private transient Map<String, List<Plot>> groupMap = new HashMap<String, List<Plot>>();
    public static final PlotDescriptor DESCRIPTOR = new PlotDescriptor();

    private Object readResolve() {
        this.setPlots(this.plots);
        return this;
    }

    public String urlGroupToOriginalGroup(String urlGroup) {
        List<Plot> plotList;
        if (urlGroup == null || "nogroup".equals(urlGroup)) {
            return "Plots";
        }
        if (this.groupMap.containsKey(urlGroup) && CollectionUtils.isNotEmpty(plotList = this.groupMap.get(urlGroup))) {
            return plotList.get((int)0).group;
        }
        return "";
    }

    public List<String> getOriginalGroups() {
        ArrayList<String> originalGroups = new ArrayList<String>();
        for (String urlGroup : this.groupMap.keySet()) {
            originalGroups.add(this.urlGroupToOriginalGroup(urlGroup));
        }
        Collections.sort(originalGroups);
        return originalGroups;
    }

    public void setPlots(List<Plot> plots) {
        this.plots = new ArrayList<Plot>();
        this.groupMap = new HashMap<String, List<Plot>>();
        for (Plot plot : plots) {
            this.addPlot(plot);
        }
    }

    public void addPlot(Plot plot) {
        this.plots.add(plot);
        String urlGroup = this.originalGroupToUrlEncodedGroup(plot.getGroup());
        if (this.groupMap.containsKey(urlGroup)) {
            List<Plot> list = this.groupMap.get(urlGroup);
            list.add(plot);
        } else {
            ArrayList<Plot> list = new ArrayList<Plot>();
            list.add(plot);
            this.groupMap.put(urlGroup, list);
        }
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new PlotAction(project, this);
    }

    public List<Plot> getPlots() {
        return this.plots;
    }

    public List<Plot> getPlots(String urlGroup) {
        ArrayList p = this.groupMap.get(urlGroup);
        return p != null ? p : new ArrayList();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        this.recordPlotData((Run<?, ?>)build, (TaskListener)listener);
        return true;
    }

    private void recordPlotData(Run<?, ?> build, TaskListener listener) {
        listener.getLogger().println("Recording plot data");
        for (Plot plot : this.getPlots()) {
            plot.addBuild((AbstractBuild)build, listener.getLogger());
        }
    }

    @Override
    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }
}

