/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.plot.CSVSeries;
import hudson.plugins.plot.Messages;
import hudson.plugins.plot.Plot;
import hudson.plugins.plot.PlotBuildAction;
import hudson.plugins.plot.PropertiesSeries;
import hudson.plugins.plot.Series;
import hudson.plugins.plot.XMLSeries;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class PlotBuilder
extends Builder
implements SimpleBuildStep {
    private final String group;
    private final String style;
    @CheckForNull
    private String title;
    @CheckForNull
    private String description;
    @CheckForNull
    private String numBuilds;
    @CheckForNull
    private String yaxis;
    @CheckForNull
    private String yaxisMinimum;
    @CheckForNull
    private String yaxisMaximum;
    private boolean useDescr;
    private boolean exclZero;
    private boolean logarithmic;
    private boolean keepRecords;
    public String csvFileName;
    public List<CSVSeries> csvSeries;
    public List<PropertiesSeries> propertiesSeries;
    public List<XMLSeries> xmlSeries;

    @DataBoundConstructor
    public PlotBuilder(String group, String style, String csvFileName) {
        this.group = group;
        this.style = style;
        this.csvFileName = csvFileName;
    }

    public String getGroup() {
        return this.group;
    }

    public String getStyle() {
        return this.style;
    }

    @CheckForNull
    public String getTitle() {
        return this.title;
    }

    @DataBoundSetter
    public final void setTitle(@CheckForNull String title) {
        this.title = Util.fixEmptyAndTrim((String)title);
    }

    @CheckForNull
    public String getNumBuilds() {
        return this.numBuilds;
    }

    @DataBoundSetter
    public final void setNumBuilds(@CheckForNull String numBuilds) {
        this.numBuilds = Util.fixEmptyAndTrim((String)numBuilds);
    }

    @CheckForNull
    public String getYaxis() {
        return this.yaxis;
    }

    @DataBoundSetter
    public final void setYaxis(@CheckForNull String yaxis) {
        this.yaxis = Util.fixEmptyAndTrim((String)yaxis);
    }

    public boolean getUseDescr() {
        return this.useDescr;
    }

    @DataBoundSetter
    public void setUseDescr(boolean useDescr) {
        this.useDescr = useDescr;
    }

    public boolean getExclZero() {
        return this.exclZero;
    }

    @DataBoundSetter
    public void setExclZero(boolean exclZero) {
        this.exclZero = exclZero;
    }

    public boolean getLogarithmic() {
        return this.logarithmic;
    }

    @DataBoundSetter
    public void setLogarithmic(boolean logarithmic) {
        this.logarithmic = logarithmic;
    }

    public boolean getKeepRecords() {
        return this.keepRecords;
    }

    @DataBoundSetter
    public void setKeepRecords(boolean keepRecords) {
        this.keepRecords = keepRecords;
    }

    @CheckForNull
    public String getYaxisMinimum() {
        return this.yaxisMinimum;
    }

    @DataBoundSetter
    public final void setYaxisMinimum(@CheckForNull String yaxisMinimum) {
        this.yaxisMinimum = Util.fixEmptyAndTrim((String)yaxisMinimum);
    }

    @CheckForNull
    public String getYaxisMaximum() {
        return this.yaxisMaximum;
    }

    @DataBoundSetter
    public final void setYaxisMaximum(@CheckForNull String yaxisMaximum) {
        this.yaxisMaximum = Util.fixEmptyAndTrim((String)yaxisMaximum);
    }

    @DataBoundSetter
    public final void setDescription(@CheckForNull String description) {
        this.description = Util.fixEmptyAndTrim((String)description);
    }

    public List<CSVSeries> getCsvSeries() {
        return this.csvSeries;
    }

    @DataBoundSetter
    public void setCsvSeries(List<CSVSeries> csvSeries) {
        this.csvSeries = csvSeries;
    }

    public List<PropertiesSeries> getPropertiesSeries() {
        return this.propertiesSeries;
    }

    @DataBoundSetter
    public void setPropertiesSeries(List<PropertiesSeries> propertiesSeries) {
        this.propertiesSeries = propertiesSeries;
    }

    public List<XMLSeries> getXmlSeries() {
        return this.xmlSeries;
    }

    @DataBoundSetter
    public void setXmlSeries(List<XMLSeries> xmlSeries) {
        this.xmlSeries = xmlSeries;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) {
        ArrayList<Plot> plots = new ArrayList<Plot>();
        Plot plot = new Plot(this.title, this.yaxis, this.group, this.numBuilds, this.csvFileName, this.style, this.useDescr, this.keepRecords, this.exclZero, this.logarithmic, this.yaxisMinimum, this.yaxisMaximum, this.description);
        ArrayList<Series> series = new ArrayList<Series>();
        if (this.csvSeries != null) {
            series.addAll(this.csvSeries);
        }
        if (this.xmlSeries != null) {
            series.addAll(this.xmlSeries);
        }
        if (this.propertiesSeries != null) {
            series.addAll(this.propertiesSeries);
        }
        plot.series = series;
        plot.addBuild(build, listener.getLogger(), workspace);
        plots.add(plot);
        PlotBuildAction buildAction = (PlotBuildAction)build.getAction(PlotBuildAction.class);
        if (buildAction == null) {
            build.addAction((Action)new PlotBuildAction(build, plots));
        } else {
            buildAction.addPlots(plots);
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    @Symbol(value={"plot"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public String getCsvFileName() {
            return "plot-" + UUID.randomUUID().toString() + ".csv";
        }

        public FormValidation doCheckName(@QueryParameter String value) throws IOException, ServletException {
            if (value == null || value.isEmpty()) {
                return FormValidation.error((String)"Please set a group");
            }
            if (value.length() < 4) {
                return FormValidation.warning((String)"Isn't the group too short?");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.Plot_Publisher_DisplayName();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

