/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.AbstractDataset;

public class PlotCategoryDataset
extends AbstractDataset
implements CategoryDataset {
    private static final long serialVersionUID = 9215482265757674967L;
    private transient List<Comparable> rowKeys = new ArrayList<Comparable>();
    private transient List<Comparable> columnKeys = new ArrayList<Comparable>();
    private transient List<Map<Comparable, DataElement>> data = new ArrayList<Map<Comparable, DataElement>>();
    private transient int maxColumns;

    public void clipDataset(int maxColumns) {
        this.maxColumns = maxColumns;
        if (this.getColumnCount() > 0) {
            Comparable lowColumn = this.getColumnKey(0);
            for (int i = this.data.size() - 1; i >= 0; --i) {
                Map<Comparable, DataElement> row = this.data.get(i);
                boolean removeRow = true;
                for (Comparable column : row.keySet()) {
                    if (column.compareTo(lowColumn) < 0) continue;
                    removeRow = false;
                    break;
                }
                if (!removeRow) continue;
                this.data.remove(i);
                this.rowKeys.remove(i);
            }
        }
    }

    public int getRowCount() {
        return this.rowKeys.size();
    }

    public int getColumnCount() {
        return Math.min(this.columnKeys.size(), this.maxColumns);
    }

    public Number getValue(int row, int column) {
        if (this.data.get(row) == null) {
            return null;
        }
        int newColumn = column;
        if (this.columnKeys.size() > this.maxColumns) {
            newColumn = this.columnKeys.size() - this.maxColumns + column;
        }
        Comparable columnKey = this.columnKeys.get(newColumn);
        DataElement element = this.data.get(row).get(columnKey);
        if (element == null) {
            return null;
        }
        return element.number;
    }

    public Comparable getRowKey(int row) {
        return this.rowKeys.get(row);
    }

    public int getRowIndex(Comparable key) {
        return this.rowKeys.indexOf(key);
    }

    public List getRowKeys() {
        return this.rowKeys;
    }

    public Comparable getColumnKey(int column) {
        int newColumn = column;
        if (this.columnKeys.size() > this.maxColumns) {
            newColumn = this.columnKeys.size() - this.maxColumns + column;
        }
        return this.columnKeys.get(newColumn);
    }

    public int getColumnIndex(Comparable key) {
        return this.columnKeys.indexOf(key);
    }

    public List getColumnKeys() {
        int firstIndex = Math.max(0, this.columnKeys.size() - this.maxColumns);
        int lastIndex = Math.max(0, this.columnKeys.size());
        return this.columnKeys.subList(firstIndex, lastIndex);
    }

    public Number getValue(Comparable rowKey, Comparable columnKey) {
        int rowIndex = this.rowKeys.indexOf(rowKey);
        if (rowIndex == -1 || this.data.get(rowIndex) == null) {
            return null;
        }
        DataElement element = this.data.get(rowIndex).get(columnKey);
        if (element == null) {
            return null;
        }
        return element.number;
    }

    public String getUrl(int row, int column) {
        if (this.data.get(row) == null) {
            return null;
        }
        int newColumn = column;
        if (this.columnKeys.size() > this.maxColumns) {
            newColumn = this.columnKeys.size() - this.maxColumns + column;
        }
        Comparable columnKey = this.columnKeys.get(newColumn);
        DataElement element = this.data.get(row).get(columnKey);
        if (element == null) {
            return null;
        }
        return element.url;
    }

    public void setValue(Number value, String url, Comparable rowKey, Comparable columnKey) {
        int rowIndex = this.rowKeys.indexOf(rowKey);
        if (rowIndex == -1) {
            this.rowKeys.add(rowKey);
            rowIndex = this.rowKeys.size() - 1;
            this.data.add(new HashMap());
        }
        if (!this.columnKeys.contains(columnKey)) {
            boolean added = false;
            for (int i = 0; i < this.columnKeys.size(); ++i) {
                Comparable key = this.columnKeys.get(i);
                if (key.compareTo(columnKey) < 0) continue;
                this.columnKeys.add(i, columnKey);
                added = true;
                break;
            }
            if (!added) {
                this.columnKeys.add(columnKey);
            }
        }
        DataElement element = new DataElement(value, url);
        this.data.get(rowIndex).put(columnKey, element);
    }

    private static class DataElement {
        private final Number number;
        private final String url;

        DataElement(Number n, String u) {
            this.number = n;
            this.url = u;
        }
    }
}

