/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.plot.Messages;
import hudson.plugins.plot.PlotCategoryDataset;
import hudson.plugins.plot.PlotPoint;
import hudson.plugins.plot.PointURLGenerator;
import hudson.plugins.plot.Series;
import hudson.util.ChartUtil;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plot
implements Comparable<Plot> {
    private static final Logger LOGGER = Logger.getLogger(Plot.class.getName());
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MMM d");
    private transient List<String[]> rawPlotData;
    private transient JFreeChart plot;
    private transient AbstractProject<?, ?> project;
    private static final DrawingSupplier supplier = new DefaultDrawingSupplier(DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, new Shape[]{new Polygon(new int[]{3, 0, -3, 0}, new int[]{0, 4, 0, -4}, 4)});
    private static final int DEFAULT_WIDTH = 750;
    private static final int DEFAULT_HEIGHT = 450;
    private static final String DEFAULT_NUMBUILDS = "";
    private transient int width;
    private transient int height;
    private transient int rightBuildNum;
    private transient boolean hasLegend = true;
    public transient String urlNumBuilds;
    public transient String urlTitle;
    public transient String urlStyle;
    public transient Boolean urlUseDescr;
    public String title;
    public String yaxis;
    public List<Series> series;
    public String group;
    public String numBuilds;
    public String csvFileName;
    private long csvLastModification;
    public String style;
    public boolean useDescr;
    private boolean keepRecords;
    public boolean exclZero;

    @DataBoundConstructor
    public Plot(String title, String yaxis, String group, String numBuilds, String csvFileName, String style, boolean useDescr, boolean keepRecords, boolean exclZero) {
        this.title = title;
        this.yaxis = yaxis;
        this.group = group;
        this.numBuilds = numBuilds;
        if (StringUtils.isBlank((String)csvFileName)) {
            csvFileName = Math.abs(new Random().nextInt()) + ".csv";
        }
        this.csvFileName = csvFileName;
        this.style = style;
        this.useDescr = useDescr;
        this.keepRecords = keepRecords;
        this.exclZero = exclZero;
    }

    @Deprecated
    public Plot(String title, String yaxis, String group, String numBuilds, String csvFileName, String style, boolean useDescr) {
        this(title, yaxis, group, numBuilds, csvFileName, style, useDescr, false, false);
    }

    public Plot() {
    }

    public boolean getKeepRecords() {
        return this.keepRecords;
    }

    public boolean getExclZero() {
        return this.exclZero;
    }

    @Override
    public int compareTo(Plot o) {
        return this.title.compareTo(o.getTitle());
    }

    public String toString() {
        return "TITLE(" + this.getTitle() + "),YAXIS(" + this.yaxis + "),NUMSERIES(" + CollectionUtils.size(this.series) + "),GROUP(" + this.group + "),NUMBUILDS(" + this.numBuilds + "),RIGHTBUILDNUM(" + this.getRightBuildNum() + "),HASLEGEND(" + this.hasLegend() + "),FILENAME(" + this.csvFileName + ")";
    }

    public String getYaxis() {
        return this.yaxis;
    }

    public List<Series> getSeries() {
        return this.series;
    }

    public String getGroup() {
        return this.group;
    }

    public String getCsvFileName() {
        return this.csvFileName;
    }

    private void setTitle(StaplerRequest req) {
        this.urlTitle = req.getParameter("title");
    }

    private String getURLTitle() {
        return this.urlTitle != null ? this.urlTitle : this.title;
    }

    public String getTitle() {
        return this.title;
    }

    private void setStyle(StaplerRequest req) {
        this.urlStyle = req.getParameter("style");
    }

    private String getUrlStyle() {
        return this.urlStyle != null ? this.urlStyle : (this.style != null ? this.style : DEFAULT_NUMBUILDS);
    }

    private void setUseDescr(StaplerRequest req) {
        String u = req.getParameter("usedescr");
        this.urlUseDescr = u == null ? null : Boolean.valueOf("on".equalsIgnoreCase(u) || "true".equalsIgnoreCase(u));
    }

    private boolean getUrlUseDescr() {
        return this.urlUseDescr != null ? this.urlUseDescr : this.useDescr;
    }

    private void setHasLegend(StaplerRequest req) {
        String legend = req.getParameter("legend");
        this.hasLegend = legend == null || "on".equalsIgnoreCase(legend) || "true".equalsIgnoreCase(legend);
    }

    public boolean hasLegend() {
        return this.hasLegend;
    }

    private void setNumBuilds(StaplerRequest req) {
        this.urlNumBuilds = req.getParameter("numbuilds");
        if (this.urlNumBuilds == null) {
            // empty if block
        }
    }

    public String getURLNumBuilds() {
        return this.urlNumBuilds != null ? this.urlNumBuilds : this.numBuilds;
    }

    public String getNumBuilds() {
        return this.numBuilds;
    }

    private void setRightBuildNum(StaplerRequest req) {
        String build = req.getParameter("rightbuildnum");
        if (build == null) {
            this.rightBuildNum = Integer.MAX_VALUE;
        } else {
            try {
                this.rightBuildNum = Integer.parseInt(build);
            }
            catch (NumberFormatException nfe) {
                LOGGER.log(Level.SEVERE, "Exception converting to integer", nfe);
                this.rightBuildNum = Integer.MAX_VALUE;
            }
        }
    }

    private int getRightBuildNum() {
        return this.rightBuildNum;
    }

    private void setWidth(StaplerRequest req) {
        String w = req.getParameter("width");
        if (w == null) {
            this.width = 750;
        } else {
            try {
                this.width = Integer.parseInt(w);
            }
            catch (NumberFormatException nfe) {
                LOGGER.log(Level.SEVERE, "Exception converting to integer", nfe);
                this.width = 750;
            }
        }
    }

    private int getWidth() {
        return this.width;
    }

    private void setHeight(StaplerRequest req) {
        String h = req.getParameter("height");
        if (h == null) {
            this.height = 450;
        } else {
            try {
                this.height = Integer.parseInt(h);
            }
            catch (NumberFormatException nfe) {
                LOGGER.log(Level.SEVERE, "Exception converting to integer", nfe);
                this.height = 450;
            }
        }
    }

    private int getHeight() {
        return this.height;
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public void setProject(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public void plotGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        this.setWidth(req);
        this.setHeight(req);
        this.setNumBuilds(req);
        this.setRightBuildNum(req);
        this.setHasLegend(req);
        this.setTitle(req);
        this.setStyle(req);
        this.setUseDescr(req);
        this.generatePlot(true);
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)this.plot, (int)this.getWidth(), (int)this.getHeight());
    }

    public void plotGraphMap(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        this.setWidth(req);
        this.setHeight(req);
        this.setNumBuilds(req);
        this.setRightBuildNum(req);
        this.setHasLegend(req);
        this.setTitle(req);
        this.setStyle(req);
        this.setUseDescr(req);
        this.generatePlot(false);
        ChartRenderingInfo info = new ChartRenderingInfo();
        this.plot.createBufferedImage(this.getWidth(), this.getHeight(), info);
        rsp.setContentType("text/plain;charset=UTF-8");
        rsp.getWriter().println(ChartUtilities.getImageMap((String)this.getCsvFileName(), (ChartRenderingInfo)info));
    }

    public void addBuild(AbstractBuild<?, ?> build, PrintStream logger) {
        if (this.project == null) {
            this.project = build.getProject();
        }
        this.loadPlotData();
        for (Series series : this.getSeries()) {
            List<PlotPoint> seriesData;
            if (series == null || (seriesData = series.loadSeries(build.getWorkspace(), logger)) == null) continue;
            for (PlotPoint point : seriesData) {
                if (point == null) continue;
                this.rawPlotData.add(new String[]{point.getYvalue(), point.getLabel(), build.getNumber() + DEFAULT_NUMBUILDS, build.getTimestamp().getTimeInMillis() + DEFAULT_NUMBUILDS, point.getUrl()});
            }
        }
        this.savePlotData();
    }

    private void generatePlot(boolean forceGenerate) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Label
        implements Comparable<Label> {
            private final Integer buildNum;
            private final String buildDate;
            private final String text;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Label(String buildNum, String buildTime, String text) {
                this.buildNum = Integer.parseInt(buildNum);
                SimpleDateFormat simpleDateFormat = DATE_FORMAT;
                synchronized (simpleDateFormat) {
                    this.buildDate = DATE_FORMAT.format(new Date(Long.parseLong(buildTime)));
                }
                this.text = text;
            }

            public Label(String buildNum, String buildTime) {
                this(buildNum, buildTime, null);
            }

            @Override
            public int compareTo(Label that) {
                return this.buildNum - that.buildNum;
            }

            public boolean equals(Object o) {
                return o instanceof Label && ((Label)o).buildNum.equals(this.buildNum);
            }

            public int hashCode() {
                return this.buildNum.hashCode();
            }

            public String numDateString() {
                return "#" + this.buildNum + " (" + this.buildDate + ")";
            }

            public String toString() {
                return this.text != null ? this.text : this.numDateString();
            }
        }
        int numBuilds;
        File csvFile = new File(this.project.getRootDir(), this.getCsvFileName());
        if (csvFile.lastModified() == this.csvLastModification && this.plot != null && !forceGenerate) {
            return;
        }
        if (this.rawPlotData == null || csvFile.lastModified() > this.csvLastModification) {
            this.loadPlotData();
        }
        this.csvLastModification = csvFile.lastModified();
        PlotCategoryDataset dataset = new PlotCategoryDataset();
        for (String[] record : this.rawPlotData) {
            int buildNum;
            block18: {
                try {
                    buildNum = Integer.valueOf(record[2]);
                    if (!this.reportBuild(buildNum)) continue;
                    if (buildNum > this.getRightBuildNum()) {
                    }
                    break block18;
                }
                catch (NumberFormatException nfe) {
                    LOGGER.log(Level.SEVERE, "Exception converting to integer", nfe);
                }
                continue;
            }
            Number value = null;
            try {
                value = Integer.valueOf(record[0]);
            }
            catch (NumberFormatException nfe) {
                try {
                    value = Double.valueOf(record[0]);
                }
                catch (NumberFormatException nfe2) {
                    LOGGER.log(Level.SEVERE, "Exception converting to number", nfe2);
                    continue;
                }
            }
            String series = record[1];
            Label xlabel = this.getUrlUseDescr() ? new Label(record[2], record[3], this.descriptionForBuild(buildNum)) : new Label(record[2], record[3]);
            String url = null;
            if (record.length >= 5) {
                url = record[4];
            }
            dataset.setValue(value, url, (Comparable)((Object)series), xlabel);
        }
        try {
            numBuilds = Integer.parseInt(this.getURLNumBuilds());
        }
        catch (NumberFormatException nfe) {
            LOGGER.log(Level.SEVERE, "Exception converting to integer", nfe);
            numBuilds = Integer.MAX_VALUE;
        }
        dataset.clipDataset(numBuilds);
        this.plot = this.createChart(dataset);
        CategoryPlot categoryPlot = (CategoryPlot)this.plot.getPlot();
        categoryPlot.setDomainGridlinePaint((Paint)Color.black);
        categoryPlot.setRangeGridlinePaint((Paint)Color.black);
        categoryPlot.setDrawingSupplier(supplier);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(Messages.Plot_Build());
        categoryPlot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.03);
        domainAxis.setCategoryMargin(0.0);
        for (Object category : dataset.getColumnKeys()) {
            Label label = (Label)category;
            if (label.text != null) {
                domainAxis.addCategoryLabelToolTip((Comparable)label, label.numDateString());
                continue;
            }
            domainAxis.addCategoryLabelToolTip((Comparable)label, this.descriptionForBuild(label.buildNum));
        }
        ValueAxis rangeAxis = categoryPlot.getRangeAxis();
        if (rangeAxis != null && rangeAxis instanceof NumberAxis) {
            ((NumberAxis)rangeAxis).setAutoRangeIncludesZero(!this.getExclZero());
        }
        AbstractCategoryItemRenderer renderer = (AbstractCategoryItemRenderer)categoryPlot.getRenderer();
        int numColors = dataset.getRowCount();
        for (int i = 0; i < numColors; ++i) {
            renderer.setSeriesPaint(i, (Paint)new Color(Color.HSBtoRGB(1.0f / (float)numColors * (float)i, 1.0f, 1.0f)));
        }
        renderer.setStroke((Stroke)new BasicStroke(2.0f));
        renderer.setToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator(Messages.Plot_Build() + " {1}: {2}", NumberFormat.getInstance()));
        renderer.setItemURLGenerator((CategoryURLGenerator)new PointURLGenerator());
        if (renderer instanceof LineAndShapeRenderer) {
            LineAndShapeRenderer lasRenderer = (LineAndShapeRenderer)renderer;
            lasRenderer.setShapesVisible(true);
        }
    }

    private JFreeChart createChart(PlotCategoryDataset dataset) {
        String s = this.getUrlStyle();
        if ("area".equalsIgnoreCase(s)) {
            return ChartFactory.createAreaChart((String)this.getURLTitle(), null, (String)this.getYaxis(), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.hasLegend(), (boolean)true, (boolean)false);
        }
        if ("bar".equalsIgnoreCase(s)) {
            return ChartFactory.createBarChart((String)this.getURLTitle(), null, (String)this.getYaxis(), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.hasLegend(), (boolean)true, (boolean)false);
        }
        if ("bar3d".equalsIgnoreCase(s)) {
            return ChartFactory.createBarChart3D((String)this.getURLTitle(), null, (String)this.getYaxis(), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.hasLegend(), (boolean)true, (boolean)false);
        }
        if ("line3d".equalsIgnoreCase(s)) {
            return ChartFactory.createLineChart3D((String)this.getURLTitle(), null, (String)this.getYaxis(), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.hasLegend(), (boolean)true, (boolean)false);
        }
        if ("stackedarea".equalsIgnoreCase(s)) {
            return ChartFactory.createStackedAreaChart((String)this.getURLTitle(), null, (String)this.getYaxis(), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.hasLegend(), (boolean)true, (boolean)false);
        }
        if ("stackedbar".equalsIgnoreCase(s)) {
            return ChartFactory.createStackedBarChart((String)this.getURLTitle(), null, (String)this.getYaxis(), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.hasLegend(), (boolean)true, (boolean)false);
        }
        if ("stackedbar3d".equalsIgnoreCase(s)) {
            return ChartFactory.createStackedBarChart3D((String)this.getURLTitle(), null, (String)this.getYaxis(), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.hasLegend(), (boolean)true, (boolean)false);
        }
        if ("waterfall".equalsIgnoreCase(s)) {
            return ChartFactory.createWaterfallChart((String)this.getURLTitle(), null, (String)this.getYaxis(), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.hasLegend(), (boolean)true, (boolean)false);
        }
        return ChartFactory.createLineChart((String)this.getURLTitle(), null, (String)this.getYaxis(), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.hasLegend(), (boolean)true, (boolean)false);
    }

    private String descriptionForBuild(int buildNum) {
        String tip;
        AbstractBuild r = this.project.getBuildByNumber(buildNum);
        if (r != null && (tip = r.getTruncatedDescription()) != null) {
            return tip.replaceAll("<p> *|<br> *", ", ");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPlotData() {
        this.rawPlotData = new ArrayList<String[]>();
        File plotFile = new File(this.project.getRootDir(), this.getCsvFileName());
        if (!plotFile.exists()) {
            return;
        }
        CSVReader reader = null;
        this.rawPlotData = new ArrayList<String[]>();
        try {
            String[] nextLine;
            reader = new CSVReader((Reader)new FileReader(plotFile));
            reader.readNext();
            reader.readNext();
            while ((nextLine = reader.readNext()) != null) {
                this.rawPlotData.add(nextLine);
            }
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Exception reading plot file", ioe);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePlotData() {
        File plotFile = new File(this.project.getRootDir(), this.getCsvFileName());
        CSVWriter writer = null;
        try {
            writer = new CSVWriter((Writer)new FileWriter(plotFile));
            String[] header1 = new String[]{Messages.Plot_Title(), this.getTitle()};
            String[] header2 = new String[]{Messages.Plot_Value(), Messages.Plot_SeriesLabel(), Messages.Plot_BuildNumber(), Messages.Plot_BuildDate(), Messages.Plot_URL()};
            writer.writeNext(header1);
            writer.writeNext(header2);
            for (String[] entry : this.rawPlotData) {
                if (!this.reportBuild(Integer.parseInt(entry[2]))) continue;
                writer.writeNext(entry);
            }
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Exception saving plot file", ioe);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    boolean reportBuild(int buildNumber) {
        int numBuilds;
        try {
            numBuilds = Integer.parseInt(this.numBuilds);
        }
        catch (NumberFormatException ex) {
            numBuilds = Integer.MAX_VALUE;
        }
        if (buildNumber < this.project.getNextBuildNumber() - numBuilds) {
            return false;
        }
        return this.keepRecords || this.project.getBuildByNumber(buildNumber) != null;
    }
}

