/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import hudson.FilePath;
import hudson.plugins.plot.PlotPoint;
import hudson.plugins.plot.Series;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;
import org.kohsuke.stapler.DataBoundConstructor;

public class PropertiesSeries
extends Series {
    @DataBoundConstructor
    public PropertiesSeries(String file, String label) {
        super(file, label, "properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlotPoint[] loadSeries(FilePath workspaceRootDir, PrintStream logger) {
        PlotPoint[] plotPointArray;
        InputStream in = null;
        FilePath[] seriesFiles = null;
        try {
            seriesFiles = workspaceRootDir.list(this.getFile());
        }
        catch (Exception e) {
            logger.println("Exception trying to retrieve series files: " + e);
            return null;
        }
        if (seriesFiles != null && seriesFiles.length < 1) {
            logger.println("No plot data file found: " + this.getFile());
            return null;
        }
        try {
            in = seriesFiles[0].read();
            logger.println("Saving plot series data from: " + seriesFiles[0]);
            Properties properties = new Properties();
            properties.load(in);
            String yvalue = properties.getProperty("YVALUE");
            String url = properties.getProperty("URL", "");
            if (yvalue == null || url == null) {
                logger.println("Not creating point with null values: y=" + yvalue + " label=" + this.getLabel() + " url=" + url);
                PlotPoint[] plotPointArray2 = null;
                return plotPointArray2;
            }
            plotPointArray = new PlotPoint[]{new PlotPoint(yvalue, url, this.getLabel())};
        }
        catch (Exception e) {
            logger.println("Exception reading plot series data from: " + seriesFiles[0]);
            PlotPoint[] plotPointArray3 = null;
            return plotPointArray3;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
        return plotPointArray;
    }
}

