/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.plaincredentials;

import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.NameWith;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import hudson.Util;
import hudson.util.Secret;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.plaincredentials.Messages;

@NameWith(value=NameProvider.class)
public interface StringCredentials
extends StandardCredentials {
    @Nonnull
    public Secret getSecret();

    public static class NameProvider
    extends CredentialsNameProvider<StringCredentials> {
        public String getName(StringCredentials c) {
            String description = Util.fixEmptyAndTrim((String)c.getDescription());
            String ID = c.getId();
            return description != null ? description : (!NameProvider.isUUID(ID) ? ID : Messages.StringCredentials_string_credentials());
        }

        private static boolean isUUID(String ID) {
            try {
                UUID.fromString(ID);
                return true;
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
        }
    }
}

