/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.plaincredentials.impl;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.Extension;
import hudson.util.IOException2;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.security.CryptoConfidentialKey;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.fileupload.FileItem;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.jenkinsci.plugins.plaincredentials.impl.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;

public final class FileCredentialsImpl
extends BaseStandardCredentials
implements FileCredentials {
    private static final CryptoConfidentialKey KEY = new CryptoConfidentialKey(FileCredentialsImpl.class.getName());
    private static final Logger LOGGER = Logger.getLogger(FileCredentialsImpl.class.getName());
    @Nonnull
    private final String fileName;
    @Nonnull
    private final byte[] data;

    @DataBoundConstructor
    public FileCredentialsImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @Nonnull FileItem file, @CheckForNull String fileName, @CheckForNull String data) throws IOException {
        super(scope, id, description);
        String name = file.getName();
        if (name.length() > 0) {
            this.fileName = name.replaceFirst("^.+[/\\\\]", "");
            byte[] unencrypted = file.get();
            try {
                this.data = KEY.encrypt().doFinal(unencrypted);
            }
            catch (GeneralSecurityException x) {
                throw new IOException2((Throwable)x);
            }
        } else {
            this.fileName = fileName;
            this.data = Base64.decodeBase64((String)data);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "for {0} have {1} of length {2} after upload of \u2018{3}\u2019", new Object[]{this.getId(), this.fileName, this.unencrypted().length, name});
        }
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Restricted(value={DoNotUse.class})
    public String getData() {
        return Base64.encodeBase64String((byte[])this.data);
    }

    private byte[] unencrypted() throws IOException {
        try {
            return KEY.decrypt().doFinal(this.data);
        }
        catch (GeneralSecurityException x) {
            throw new IOException2((Throwable)x);
        }
    }

    @Override
    public InputStream getContent() throws IOException {
        return new ByteArrayInputStream(this.unencrypted());
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return Messages.FileCredentialsImpl_secret_file();
        }
    }
}

