/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.zip;

import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.zip.UnZipStep;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class UnZipStepExecution
extends SynchronousNonBlockingStepExecution<Object> {
    private static final long serialVersionUID = 1L;
    private transient UnZipStep step;

    protected UnZipStepExecution(@Nonnull UnZipStep step, @Nonnull StepContext context) {
        super(context);
        this.step = step;
    }

    protected Object run() throws Exception {
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        assert (listener != null);
        FilePath ws = (FilePath)this.getContext().get(FilePath.class);
        assert (ws != null);
        if (this.step.isTest()) {
            return this.test();
        }
        FilePath source = ws.child(this.step.getZipFile());
        if (!source.exists()) {
            throw new IOException(source.getRemote() + " does not exist.");
        }
        if (source.isDirectory()) {
            throw new IOException(source.getRemote() + " is a directory.");
        }
        FilePath destination = ws;
        if (!StringUtils.isBlank((String)this.step.getDir())) {
            destination = ws.child(this.step.getDir());
        }
        return source.act((FilePath.FileCallable)new UnZipFileCallable(listener, destination, this.step.getGlob(), this.step.isRead(), this.step.getCharset(), this.step.isQuiet()));
    }

    private Boolean test() throws IOException, InterruptedException {
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        assert (listener != null);
        FilePath ws = (FilePath)this.getContext().get(FilePath.class);
        assert (ws != null);
        FilePath source = ws.child(this.step.getZipFile());
        if (!source.exists()) {
            listener.error(source.getRemote() + " does not exist.");
            return false;
        }
        if (source.isDirectory()) {
            listener.error(source.getRemote() + " is a directory.");
            return false;
        }
        return (Boolean)source.act((FilePath.FileCallable)new TestZipFileCallable(listener));
    }

    static class TestZipFileCallable
    extends MasterToSlaveFileCallable<Boolean> {
        private TaskListener listener;

        public TestZipFileCallable(TaskListener listener) {
            this.listener = listener;
        }

        /*
         * Exception decompiling
         */
        public Boolean invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 28[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static class UnZipFileCallable
    extends MasterToSlaveFileCallable<Map<String, String>> {
        private final TaskListener listener;
        private final FilePath destination;
        private final String glob;
        private final boolean read;
        private final boolean quiet;
        private final String charset;

        public UnZipFileCallable(TaskListener listener, FilePath destination, String glob, boolean read, String charset, boolean quiet) {
            this.listener = listener;
            this.destination = destination;
            this.glob = glob;
            this.read = read;
            this.charset = charset;
            this.quiet = quiet;
        }

        /*
         * Loose catch block
         */
        public Map<String, String> invoke(File zipFile, VirtualChannel channel) throws IOException, InterruptedException {
            if (!this.read) {
                this.destination.mkdirs();
            }
            PrintStream logger = this.listener.getLogger();
            boolean doGlob = !StringUtils.isBlank((String)this.glob);
            TreeMap<String, String> strMap = new TreeMap<String, String>();
            try {
                try (ZipFile zip = new ZipFile(zipFile, Charset.forName(this.charset));){
                    TreeMap<String, String> treeMap;
                    logger.println("Extracting from " + zipFile.getAbsolutePath());
                    Enumeration<? extends ZipEntry> entries = zip.entries();
                    Integer fileCount = 0;
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (doGlob && !this.matches(entry.getName(), this.glob)) continue;
                        FilePath f = this.destination.child(entry.getName());
                        if (entry.isDirectory()) {
                            if (this.read) continue;
                            f.mkdirs();
                            continue;
                        }
                        Integer n = fileCount;
                        fileCount = fileCount + 1;
                        Serializable serializable = fileCount;
                        if (!this.read) {
                            if (!this.quiet) {
                                logger.print("Extracting: ");
                                logger.print(entry.getName());
                                logger.print(" -> ");
                                logger.println(f.getRemote());
                            }
                            InputStream inputStream = zip.getInputStream(entry);
                            serializable = null;
                            try {
                                OutputStream outputStream = f.write();
                                Throwable throwable = null;
                                try {
                                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                                    outputStream.flush();
                                    continue;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (outputStream == null) continue;
                                    if (throwable != null) {
                                        try {
                                            outputStream.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        continue;
                                    }
                                    outputStream.close();
                                    continue;
                                }
                            }
                            catch (Throwable throwable) {
                                serializable = throwable;
                                throw throwable;
                            }
                            finally {
                                if (inputStream == null) continue;
                                if (serializable != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)serializable).addSuppressed(throwable);
                                    }
                                    continue;
                                }
                                inputStream.close();
                                continue;
                            }
                        }
                        if (!this.quiet) {
                            logger.print("Reading: ");
                            logger.println(entry.getName());
                        }
                        InputStream is = zip.getInputStream(entry);
                        serializable = null;
                        try {
                            strMap.put(entry.getName(), IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset()));
                        }
                        catch (Throwable throwable) {
                            serializable = throwable;
                            throw throwable;
                        }
                        finally {
                            if (is == null) continue;
                            if (serializable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)serializable).addSuppressed(throwable);
                                }
                                continue;
                            }
                            is.close();
                        }
                    }
                    if (this.read) {
                        logger.print("Read: ");
                        logger.print(fileCount);
                        logger.println(" files");
                        treeMap = strMap;
                        return treeMap;
                    }
                    logger.print("Extracted: ");
                    logger.print(fileCount);
                    logger.println(" files");
                    treeMap = null;
                    return treeMap;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                logger.flush();
            }
        }

        boolean matches(String path, String glob) {
            String safeGlob = glob.replace('/', File.separatorChar);
            String safePath = path.replace('/', File.separatorChar);
            return SelectorUtils.matchPath((String)safeGlob, (String)safePath);
        }
    }
}

