/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.csv;

import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.TaskListener;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.csv.CSVFormat;
import org.jenkinsci.plugins.pipeline.utility.steps.csv.Messages;
import org.jenkinsci.plugins.pipeline.utility.steps.csv.WriteCSVStepExecution;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class WriteCSVStep
extends Step {
    private String file;
    private CSVFormat format;
    private Iterable<?> records;

    @DataBoundConstructor
    public WriteCSVStep(String file, Iterable<?> records) {
        this.file = Util.fixNull((String)file);
        this.format = CSVFormat.DEFAULT;
        this.records = records;
    }

    public String getFile() {
        return this.file;
    }

    public Iterable<?> getRecords() {
        return this.records;
    }

    public CSVFormat getFormat() {
        return this.format;
    }

    @DataBoundSetter
    public void setFormat(CSVFormat format) {
        this.format = format;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new WriteCSVStepExecution(this, context);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class, FilePath.class);
        }

        public String getFunctionName() {
            return "writeCSV";
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.WriteCSVStep_DescriptorImpl_displayName();
        }
    }
}

