/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.csv;

import hudson.FilePath;
import java.io.FileNotFoundException;
import java.io.OutputStreamWriter;
import javax.annotation.Nonnull;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.csv.Messages;
import org.jenkinsci.plugins.pipeline.utility.steps.csv.WriteCSVStep;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class WriteCSVStepExecution
extends SynchronousNonBlockingStepExecution<Void> {
    private static final long serialVersionUID = 1L;
    private final transient WriteCSVStep step;

    protected WriteCSVStepExecution(@Nonnull WriteCSVStep step, @Nonnull StepContext context) {
        super(context);
        this.step = step;
    }

    protected Void run() throws Exception {
        FilePath ws = (FilePath)this.getContext().get(FilePath.class);
        assert (ws != null);
        Iterable<?> records = this.step.getRecords();
        if (records == null) {
            throw new IllegalArgumentException(Messages.WriteCSVStepExecution_missingRecords(this.step.getDescriptor().getFunctionName()));
        }
        String file = this.step.getFile();
        if (StringUtils.isBlank((String)file)) {
            throw new IllegalArgumentException(Messages.WriteCSVStepExecution_missingFile(this.step.getDescriptor().getFunctionName()));
        }
        FilePath path = ws.child(file);
        if (path.isDirectory()) {
            throw new FileNotFoundException(Messages.CSVStepExecution_fileIsDirectory(path.getRemote()));
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(path.write(), "UTF-8");){
            CSVFormat format = this.step.getFormat();
            if (format == null) {
                format = CSVFormat.DEFAULT;
            }
            CSVPrinter printer = new CSVPrinter((Appendable)writer, format);
            printer.printRecords(records);
        }
        return null;
    }
}

